/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.spring.actuate;

import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.util.Assert;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.core.methods.response.NetListening;

public class Web3jHealthIndicator
extends AbstractHealthIndicator {
    private Web3j web3j;

    public Web3jHealthIndicator(Web3j web3j) {
        Assert.notNull((Object)web3j, (String)"Web3j must not be null");
        this.web3j = web3j;
    }

    protected void doHealthCheck(Health.Builder builder) throws Exception {
        try {
            boolean listening = ((NetListening)this.web3j.netListening().send()).isListening();
            if (!listening) {
                builder.down();
            } else {
                builder.up();
                ArrayList<CompletionStage> futures = new ArrayList<CompletionStage>();
                futures.add(this.web3j.netVersion().sendAsync().thenApply(netVersion -> builder.withDetail("netVersion", (Object)netVersion.getNetVersion())));
                futures.add(this.web3j.web3ClientVersion().sendAsync().thenApply(web3ClientVersion -> builder.withDetail("clientVersion", (Object)web3ClientVersion.getWeb3ClientVersion())));
                futures.add(this.web3j.ethBlockNumber().sendAsync().thenApply(ethBlockNumber -> builder.withDetail("blockNumber", (Object)ethBlockNumber.getBlockNumber())));
                futures.add(this.web3j.ethProtocolVersion().sendAsync().thenApply(ethProtocolVersion -> builder.withDetail("protocolVersion", (Object)ethProtocolVersion.getProtocolVersion())));
                futures.add(this.web3j.netPeerCount().sendAsync().thenApply(netPeerCount -> builder.withDetail("netPeerCount", (Object)netPeerCount.getQuantity())));
                CompletableFuture.allOf(futures.toArray(new CompletableFuture[futures.size()])).get();
            }
        }
        catch (Exception ex) {
            builder.down((Throwable)ex);
        }
    }
}

