/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.spring.autoconfigure;

import java.util.concurrent.TimeUnit;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.Web3jService;
import org.web3j.protocol.admin.Admin;
import org.web3j.protocol.http.HttpService;
import org.web3j.protocol.ipc.UnixIpcService;
import org.web3j.protocol.ipc.WindowsIpcService;
import org.web3j.spring.actuate.Web3jHealthIndicator;
import org.web3j.spring.autoconfigure.Web3jProperties;

@Configuration
@ConditionalOnClass(value={Web3j.class})
@EnableConfigurationProperties(value={Web3jProperties.class})
public class Web3jAutoConfiguration {
    private static Log log = LogFactory.getLog(Web3jAutoConfiguration.class);
    @Autowired
    private Web3jProperties properties;

    @Bean
    @ConditionalOnMissingBean
    public Web3j web3j() {
        Web3jService web3jService = this.buildService(this.properties.getClientAddress());
        log.info((Object)("Building service for endpoint: " + this.properties.getClientAddress()));
        return Web3j.build((Web3jService)web3jService);
    }

    @Bean
    @ConditionalOnProperty(prefix="web3j", name={"admin-client"}, havingValue="true")
    public Admin admin() {
        Web3jService web3jService = this.buildService(this.properties.getClientAddress());
        log.info((Object)("Building admin service for endpoint: " + this.properties.getClientAddress()));
        return Admin.build((Web3jService)web3jService);
    }

    private Web3jService buildService(String clientAddress) {
        Object web3jService = clientAddress == null || clientAddress.equals("") ? new HttpService(this.createOkHttpClient()) : (clientAddress.startsWith("http") ? new HttpService(clientAddress, this.createOkHttpClient(), false) : (System.getProperty("os.name").toLowerCase().startsWith("win") ? new WindowsIpcService(clientAddress) : new UnixIpcService(clientAddress)));
        return web3jService;
    }

    private OkHttpClient createOkHttpClient() {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        Web3jAutoConfiguration.configureLogging(builder);
        this.configureTimeouts(builder);
        return builder.build();
    }

    private void configureTimeouts(OkHttpClient.Builder builder) {
        Long tos = this.properties.getHttpTimeoutSeconds();
        if (tos != null) {
            builder.connectTimeout(tos.longValue(), TimeUnit.SECONDS);
            builder.readTimeout(tos.longValue(), TimeUnit.SECONDS);
            builder.writeTimeout(tos.longValue(), TimeUnit.SECONDS);
        }
    }

    private static void configureLogging(OkHttpClient.Builder builder) {
        if (log.isDebugEnabled()) {
            HttpLoggingInterceptor logging = new HttpLoggingInterceptor(arg_0 -> ((Log)log).debug(arg_0));
            logging.setLevel(HttpLoggingInterceptor.Level.BODY);
            builder.addInterceptor((Interceptor)logging);
        }
    }

    @Bean
    @ConditionalOnBean(value={Web3j.class})
    Web3jHealthIndicator web3jHealthIndicator(Web3j web3j) {
        return new Web3jHealthIndicator(web3j);
    }
}

