Ext.define("Ext.google.ux.Client",{extend:"Ext.Mixin",mixins:["Ext.mixin.Mashup"],requiredScripts:["//apis.google.com/js/client.js?onload=_ext_google_ux_client_initialize_"],statics:{getApiVersion:function(b){var a=this.libraries[b];return a&&a.state==2?a.version:null}},mixinConfig:{extended:function(c,a,b){this.load(b.googleApis)}},onClassMixedIn:function(a){this.load(a.prototype.googleApis)},privates:{statics:{initialized:false,blocked:false,loading:0,libraries:{},load:function(d){var c=this.libraries,a,b;if(!Ext.isObject(d)){return}Ext.Object.each(d,function(f,e){a=e.version||"v1";b=c[f];if(!Ext.isDefined(b)){c[f]={version:a,state:0}}else{if(b.version!==a){Ext.log.error('Google API: failed to load version "'+a+'" of the','"'+f+'" API: "'+b.version+'" already loaded.')}}});this.refresh()},refresh:function(){var a=this;if(!a.blocked){Ext.env.Ready.block();a.blocked=true}if(!a.initialized){return}Ext.Object.each(a.libraries,function(c,b){if(b.state==0){b.state=1;gapi.client.load(c,b.version,function(){b.state=2;if(!--a.loading){a.refresh()}})}if(b.state==1){a.loading++}});if(!a.loading&&a.blocked){Ext.env.Ready.unblock();a.blocked=false}},initialize:function(){this.initialized=true;this.refresh()}}}});_ext_google_ux_client_initialize_=function(){gapi.auth.init(function(){Ext.google.ux.Client.initialize()})};Ext.define("Ext.google.data.AbstractProxy",{extend:"Ext.data.proxy.Server",mixins:["Ext.google.ux.Client"],batchActions:false,reader:{type:"json",rootProperty:"items",messageProperty:"error"},doRequest:function(a){var d=this,c=d.buildRequest(a),e=d.getWriter(),b=false;if(e&&a.allowWrite()){c=e.write(c)}d.execute(d.buildApiRequests(c)).then(function(f){d.processApiResponse(a,c,f)});return c},buildUrl:function(a){return""},privates:{execute:function(b){b=[].concat(b);var a=[];return Ext.Array.reduce(b,function(d,c){return d.then(function(){return c.then(function(e){a.push(e)})})},Ext.Deferred.resolved()).then(function(){return{result:a}})},processApiResponse:function(a,d,e){var b=false,c=[];Ext.each(Object.keys(e.result),function(g){var f=e.result[g].result;if(f.error){b=f.error.message;return false}c.push(f)});this.processResponse(true,a,d,{results:b?[]:c,success:!b,error:b})},sanitizeItems:function(a){var b=[],c=[];Ext.Array.each(a,function(d){if(!Ext.Array.contains(c,d.id)){b.push(d);c.push(d.id)}},this,true);return b}}});Ext.define("Ext.google.data.EventsProxy",{extend:"Ext.google.data.AbstractProxy",alias:"proxy.google-events",googleApis:{calendar:{version:"v3"}},buildApiRequests:function(b){var a=this,c=b.getAction();switch(c){case"read":return a.buildReadApiRequests(b);case"create":return a.buildCreateApiRequests(b);case"update":return a.buildUpdateApiRequests(b);case"destroy":return a.buildDestroyApiRequests(b);default:Ext.raise("unsupported request: events."+c);return null}},extractResponseData:function(b){var c=this,d=c.callParent(arguments),a=[];Ext.each(d.results,function(e){switch(e.kind){case"calendar#events":a=a.concat(e.items.map(c.fromApiEvent.bind(c)));break;case"calendar#event":a.push(c.fromApiEvent(e));break;default:break}});return{items:c.sanitizeItems(a),success:d.success,error:d.error}},privates:{toApiEvent:function(c,b){var a={};Ext.Object.each(c,function(e,g){var f=null,d=null;switch(e){case"calendarId":case"description":a[e]=g;break;case"id":a.eventId=g;break;case"title":a.summary=g;break;case"startDate":case"endDate":if(b){d=new Date(g);d.setHours(0,-d.getTimezoneOffset());d=Ext.Date.format(d,"Y-m-d")}else{f=Ext.Date.format(new Date(g),"c")}a[e.slice(0,-4)]={date:d,dateTime:f};break;default:break}});return a},fromApiEvent:function(b){var a={allDay:true};Ext.Object.each(b,function(d,f){var c,g,e;switch(d){case"id":case"description":a[d]=f;break;case"summary":a.title=f;break;case"start":case"end":c=Ext.Date.parse(f.dateTime||f.date,"C");g=c.getTimezoneOffset();e=!!f.date;if(e&&g!==0){c.setHours(0,-g)}a[d+"Date"]=c;a.allDay=a.allDay&&e;break;default:break}});return a},buildReadApiRequests:function(d){var b=d.getParams(),f=new Date(b.startDate),a=new Date(b.endDate),e=[],c;while(f<a){c=Ext.Date.add(f,Ext.Date.MONTH,3);if(c>a){c=a}e.push(gapi.client.calendar.events.list({calendarId:b.calendar,timeMin:Ext.Date.format(f,"C"),timeMax:Ext.Date.format(c,"C"),singleEvents:true,maxResults:2500}));f=c}return e},buildCreateApiRequests:function(b){var a=b.getRecords()[0];return gapi.client.calendar.events.insert(this.toApiEvent(b.getJsonData(),a.get("allDay")))},buildUpdateApiRequests:function(d){var a=d.getRecords()[0],f=this.toApiEvent(d.getJsonData(),a.get("allDay")),c=a.getModified("calendarId"),e=a.get("calendarId"),b=a.getId(),g=[];f.calendarId=e;f.eventId=b;if(c&&c!==e){g.push(gapi.client.calendar.events.move({destination:e,calendarId:c,eventId:b}))}if(Object.keys(f).length>2){g.push(gapi.client.calendar.events.patch(f))}return g},buildDestroyApiRequests:function(b){var a=b.getRecords()[0];data=b.getJsonData();data.calendarId=data.calendarId||a.get("calendarId")||a.getPrevious("calendarId");return gapi.client.calendar.events["delete"]({calendarId:data.calendarId,eventId:data.id})}}});Ext.define("Ext.google.data.CalendarsProxy",{extend:"Ext.google.data.AbstractProxy",alias:"proxy.google-calendars",requires:["Ext.google.data.EventsProxy"],googleApis:{calendar:{version:"v3"}},buildApiRequests:function(b){var a=this,c=b.getAction();switch(c){case"read":return a.buildReadApiRequests(b);case"update":return a.buildUpdateApiRequests(b);default:Ext.raise("unsupported request: calendars."+c);return null}},extractResponseData:function(b){var c=this,d=c.callParent(arguments),a=[];Ext.each(d.results,function(e){switch(e.kind){case"calendar#calendarList":a=a.concat(e.items.map(c.fromApiCalendar.bind(c)));break;default:break}});return{items:c.sanitizeItems(a),success:d.success,error:d.error}},privates:{toApiCalendar:function(b){var a={};Ext.Object.each(b,function(c,d){switch(c){case"id":a.calendarId=d;break;case"hidden":a.selected=!d;break;default:break}});return a},fromApiCalendar:function(b){var a={hidden:!b.selected,editable:false,eventStore:{autoSync:true,proxy:{type:"google-events",resourceTypes:"events"}}};Ext.Object.each(b,function(c,d){switch(c){case"id":case"description":a[c]=d;break;case"backgroundColor":a.color=d;break;case"summary":a.title=d;break;case"accessRole":a.editable=(d=="owner"||d=="writer");break;default:break}});return a},buildReadApiRequests:function(a){return gapi.client.calendar.calendarList.list()},buildUpdateApiRequests:function(a){var b=this.toApiCalendar(a.getJsonData());return gapi.client.calendar.calendarList.patch(b)}}});Ext.define("Ext.ux.google.Api",{mixins:["Ext.mixin.Mashup"],requiredScripts:["//www.google.com/jsapi"],statics:{loadedModules:{}},onClassExtended:function(c,d,a){var e=a.onBeforeCreated,b=this;a.onBeforeCreated=function(q,j){var n=this,k=[],o=Ext.Array.from(j.requiresGoogle),m=b.loadedModules,g=0,p=function(){if(!--g){e.call(n,q,j,a)}Ext.env.Ready.unblock()},l,h,f;f=o.length;for(h=0;h<f;++h){if(Ext.isString(l=o[h])){k.push({api:l})}else{if(Ext.isObject(l)){k.push(Ext.apply({},l))}}}Ext.each(k,function(t){var r=t.api,i=String(t.version||"1.x"),s=m[r];if(!s){++g;Ext.env.Ready.block();m[r]=s=[p].concat(t.callback||[]);delete t.api;delete t.version;if(!window.google){Ext.raise("'google' is not defined.");return false}google.load(r,i,Ext.applyIf({callback:function(){m[r]=true;for(var u=s.length;u-->0;){s[u]()}}},t))}else{if(s!==true){s.push(p)}}});if(!g){e.call(n,q,j,a)}}}});Ext.define("Ext.ux.google.Feeds",{extend:"Ext.ux.google.Api",requiresGoogle:{api:"feeds",nocss:true}});Ext.define("Ext.ux.google.Map",{extend:"Ext.Container",xtype:["map","google-map"],alternateClassName:"Ext.Map",requires:["Ext.util.Geolocation"],mixins:["Ext.mixin.Mashup"],requiredScripts:["//maps.googleapis.com/maps/api/js"],isMap:true,config:{baseCls:Ext.baseCSSPrefix+"map",useCurrentLocation:false,map:null,geo:null,mapOptions:{},mapListeners:null},constructor:function(a){this.callParent([a]);if(!(window.google||{}).maps){this.setHtml("Google Maps API is required")}},initialize:function(){this.callParent();this.initMap();this.on({painted:"doResize",scope:this});this.innerElement.on("touchstart","onTouchStart",this)},initMap:function(){var f=this.getMap();if(!f){var e=(window.google||{}).maps;if(!e){return null}var b=this.mapContainer,a=this.getMapOptions(),d=e.event,c=this;if(b.dom.firstChild){Ext.fly(b.dom.firstChild).destroy()}if(Ext.os.is.iPad){Ext.merge({navigationControlOptions:{style:e.NavigationControlStyle.ZOOM_PAN}},a)}a.mapTypeId=a.mapTypeId||e.MapTypeId.ROADMAP;a.center=a.center||new e.LatLng(37.381592,-122.135672);if(a.center&&a.center.latitude&&!Ext.isFunction(a.center.lat)){a.center=new e.LatLng(a.center.latitude,a.center.longitude)}a.zoom=a.zoom||12;f=new e.Map(b.dom,a);this.setMap(f);d.addListener(f,"zoom_changed",Ext.bind(c.onZoomChange,c));d.addListener(f,"maptypeid_changed",Ext.bind(c.onTypeChange,c));d.addListener(f,"center_changed",Ext.bind(c.onCenterChange,c));d.addListenerOnce(f,"tilesloaded",Ext.bind(c.onTilesLoaded,c));this.addMapListeners()}return this.getMap()},renderMap:function(){this.initMap()},getElementConfig:function(){return{reference:"element",className:"x-container",children:[{reference:"innerElement",className:"x-inner",children:[{reference:"mapContainer",className:Ext.baseCSSPrefix+"map-container"}]}]}},onTouchStart:function(a){a.makeUnpreventable()},applyMapOptions:function(a){return Ext.merge({},this.options,a)},updateMapOptions:function(c){var b=(window.google||{}).maps,a=this.getMap();if(b&&a){a.setOptions(c)}},doMapCenter:function(){this.setMapCenter(this.getMapOptions().center)},getMapOptions:function(){return Ext.merge({},this.options||this.getInitialConfig("mapOptions"))},updateUseCurrentLocation:function(a){this.setGeo(a);if(!a){this.setMapCenter()}},applyGeo:function(a){return Ext.factory(a,Ext.util.Geolocation,this.getGeo())},updateGeo:function(b,a){var c={locationupdate:"onGeoUpdate",locationerror:"onGeoError",scope:this};if(a){a.un(c)}if(b){b.on(c);b.updateLocation()}},doResize:function(){var b=(window.google||{}).maps,a=this.getMap();if(b&&a){b.event.trigger(a,"resize")}},onTilesLoaded:function(){this.fireEvent("maprender",this,this.getMap())},addMapListeners:function(){var e=(window.google||{}).maps,a=this.getMap(),j=this.getMapListeners();if(e){var b=e.event,h=this,d,k,i,g,f;if(Ext.isSimpleObject(j)){for(var c in j){d=j[c];if(Ext.isSimpleObject(d)){k=d.scope;i=d.fn}else{if(Ext.isFunction(d)){k=null;i=d}}if(i){g=function(){this.fn.apply(this.scope,[h]);if(this.handle){b.removeListener(this.handle);delete this.handle;delete this.fn;delete this.scope}};f=b.addListener(a,c,Ext.bind(g,g));g.fn=i;g.scope=k;if(d.single===true){g.handle=f}}}}}},onGeoUpdate:function(a){if(a){this.setMapCenter(new google.maps.LatLng(a.getLatitude(),a.getLongitude()))}},onGeoError:Ext.emptyFn,setMapCenter:function(e){var b=this,d=b.getMap(),a=b.getMapOptions(),c=(window.google||{}).maps;if(c){if(!e){if(d&&d.getCenter){e=d.getCenter()}else{if(a.hasOwnProperty("center")){e=a.center}else{e=new c.LatLng(37.381592,-122.135672)}}}if(e&&!(e instanceof c.LatLng)&&"longitude" in e){e=new c.LatLng(e.latitude,e.longitude)}if(!d){a.center=a.center||e;b.renderMap();d=b.getMap()}if(d&&e instanceof c.LatLng){d.panTo(e)}else{this.options=Ext.apply(this.getMapOptions(),{center:e})}}},onZoomChange:function(){var a=this.getMapOptions(),c=this.getMap(),b;b=(c&&c.getZoom)?c.getZoom():a.zoom||10;this.options=Ext.apply(a,{zoom:b});this.fireEvent("zoomchange",this,c,b)},onTypeChange:function(){var b=this.getMapOptions(),c=this.getMap(),a;a=(c&&c.getMapTypeId)?c.getMapTypeId():b.mapTypeId;this.options=Ext.apply(b,{mapTypeId:a});this.fireEvent("typechange",this,c,a)},onCenterChange:function(){var b=this.getMapOptions(),c=this.getMap(),a;a=(c&&c.getCenter)?c.getCenter():b.center;this.options=Ext.apply(b,{center:a});this.fireEvent("centerchange",this,c,a)},doDestroy:function(){Ext.destroy(this.getGeo());var a=this.getMap();if(a&&(window.google||{}).maps){google.maps.event.clearInstanceListeners(a)}this.callParent()}});