/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.frontend2.impl;

import com.webpieces.http2engine.api.error.ConnectionCancelled;
import com.webpieces.http2engine.api.error.FarEndClosedConnection;
import com.webpieces.http2engine.api.error.ShutdownStream;
import com.webpieces.http2engine.api.server.Http2ServerEngine;
import com.webpieces.http2parser.api.dto.CancelReason;
import java.net.InetSocketAddress;
import org.webpieces.frontend2.api.FrontendSocket;
import org.webpieces.frontend2.api.ServerSocketInfo;
import org.webpieces.frontend2.api.StreamListener;
import org.webpieces.frontend2.impl.Http1_1StreamImpl;
import org.webpieces.frontend2.impl.ProtocolType;
import org.webpieces.httpparser.api.MarshalState;
import org.webpieces.httpparser.api.Memento;
import org.webpieces.nio.api.channels.ChannelSession;
import org.webpieces.nio.api.channels.TCPChannel;
import org.webpieces.util.locking.PermitQueue;
import org.webpieces.util.logging.Logger;
import org.webpieces.util.logging.LoggerFactory;

public class FrontendSocketImpl
implements FrontendSocket {
    private static final Logger log = LoggerFactory.getLogger(FrontendSocketImpl.class);
    private TCPChannel channel;
    private ProtocolType protocol;
    private Memento http1_1ParseState;
    private Http2ServerEngine http2Engine;
    private boolean isClosed;
    private ServerSocketInfo svrSocketInfo;
    private MarshalState http1_1MarshalState;
    private PermitQueue permitQueue = new PermitQueue(1);
    private Http1_1StreamImpl currentStream;

    public FrontendSocketImpl(TCPChannel channel, ProtocolType protocol, ServerSocketInfo svrSocketInfo) {
        this.channel = channel;
        this.protocol = protocol;
        this.svrSocketInfo = svrSocketInfo;
    }

    @Override
    public ProtocolType getProtocol() {
        return this.protocol;
    }

    @Override
    public void close(String reason) {
        this.internalClose();
    }

    public void internalClose() {
        this.isClosed = true;
        this.channel.close();
    }

    public void setHttp1_1ParseState(Memento parseState, MarshalState marshalState) {
        this.http1_1ParseState = parseState;
        this.http1_1MarshalState = marshalState;
    }

    public Memento getHttp1_1ParseState() {
        return this.http1_1ParseState;
    }

    public MarshalState getHttp1_1MarshalState() {
        return this.http1_1MarshalState;
    }

    public void setProtocol(ProtocolType protocol) {
        this.protocol = protocol;
    }

    public void setHttp2Engine(Http2ServerEngine engine) {
        this.http2Engine = engine;
    }

    public Http2ServerEngine getHttp2Engine() {
        return this.http2Engine;
    }

    public TCPChannel getChannel() {
        return this.channel;
    }

    public void farEndClosed(StreamListener httpListener) {
        this.isClosed = true;
        FarEndClosedConnection conn = new FarEndClosedConnection(this + " The far end closed the socket");
        if (this.protocol == ProtocolType.HTTP1_1) {
            this.cancelAllStreams(httpListener, conn);
        }
    }

    private void cancelAllStreams(StreamListener httpListener, FarEndClosedConnection f) {
        Http1_1StreamImpl stream = this.getCurrentStream();
        if (stream == null) {
            return;
        }
        ShutdownStream shutdown = new ShutdownStream(stream.getStreamId(), (ConnectionCancelled)f);
        stream.getStreamHandle().incomingCancel((CancelReason)shutdown);
    }

    @Override
    public ChannelSession getSession() {
        return this.channel.getSession();
    }

    public String toString() {
        return "HttpSocket[" + this.channel + "]";
    }

    @Override
    public boolean isHttps() {
        return this.svrSocketInfo.isHttps();
    }

    @Override
    public InetSocketAddress getServerLocalBoundAddress() {
        return this.svrSocketInfo.getLocalBoundAddress();
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        return this.channel.getLocalAddress();
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        return this.channel.getRemoteAddress();
    }

    public PermitQueue getPermitQueue() {
        return this.permitQueue;
    }

    public void setCurrentStream(Http1_1StreamImpl currentStream) {
        this.currentStream = currentStream;
    }

    public Http1_1StreamImpl getCurrentStream() {
        return this.currentStream;
    }
}

