/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.frontend2.impl;

import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import org.webpieces.asyncserver.api.AsyncDataListener;
import org.webpieces.frontend2.api.ServerSocketInfo;
import org.webpieces.frontend2.impl.FrontendSocketImpl;
import org.webpieces.frontend2.impl.InitiationResult;
import org.webpieces.frontend2.impl.InitiationStatus;
import org.webpieces.frontend2.impl.Layer2Http1_1Handler;
import org.webpieces.frontend2.impl.Layer2Http2Handler;
import org.webpieces.frontend2.impl.ProtocolType;
import org.webpieces.httpparser.api.ParseException;
import org.webpieces.nio.api.channels.Channel;
import org.webpieces.nio.api.channels.TCPChannel;
import org.webpieces.util.logging.Logger;
import org.webpieces.util.logging.LoggerFactory;

public class Layer1ServerListener
implements AsyncDataListener {
    private static final Logger log = LoggerFactory.getLogger(Layer1ServerListener.class);
    private static final String FRONTEND_SOCKET = "__frontendSocket";
    private Layer2Http1_1Handler http1_1Handler;
    private Layer2Http2Handler http2Handler;
    private ServerSocketInfo svrSocketInfo;

    public Layer1ServerListener(Layer2Http1_1Handler http1_1Listener, Layer2Http2Handler http2Listener, boolean isHttps) {
        this.http1_1Handler = http1_1Listener;
        this.http2Handler = http2Listener;
        this.svrSocketInfo = new ServerSocketInfo(isHttps);
    }

    public CompletableFuture<Void> incomingData(Channel channel, ByteBuffer b) {
        FrontendSocketImpl socket = this.getSocket(channel);
        switch (socket.getProtocol()) {
            case HTTP2: {
                return this.http2Handler.incomingData(socket, b);
            }
            case HTTP1_1: {
                return this.http1_1Handler.incomingData(socket, b);
            }
            case UNKNOWN: {
                this.initialData(b, socket);
                return CompletableFuture.completedFuture(null);
            }
        }
        throw new IllegalStateException("Unknown protocol=" + (Object)((Object)socket.getProtocol()));
    }

    private void initialData(ByteBuffer b, FrontendSocketImpl socket) {
        InitiationResult initialData;
        try {
            initialData = this.http1_1Handler.initialData(socket, b);
        }
        catch (ParseException e) {
            log.info("Parse exception on initial connection", (Throwable)e);
            socket.close("reason not needed");
            return;
        }
        if (initialData == null) {
            return;
        }
        if (initialData.getInitialStatus() == InitiationStatus.HTTP1_1) {
            socket.setProtocol(ProtocolType.HTTP1_1);
        } else if (initialData.getInitialStatus() == InitiationStatus.PREFACE) {
            socket.setProtocol(ProtocolType.HTTP2);
            this.http2Handler.initialize(socket);
            this.http2Handler.incomingData(socket, initialData.getLeftOverData());
        } else {
            throw new UnsupportedOperationException("Did not implement case=" + (Object)((Object)initialData.getInitialStatus()) + " yet");
        }
    }

    public void farEndClosed(Channel channel) {
        FrontendSocketImpl socket = this.getSocket(channel);
        switch (socket.getProtocol()) {
            case HTTP2: {
                this.http2Handler.farEndClosed(socket);
                break;
            }
            case HTTP1_1: {
                this.http1_1Handler.farEndClosed(socket);
                break;
            }
            case UNKNOWN: {
                break;
            }
            default: {
                throw new IllegalStateException("Unknown protocol=" + (Object)((Object)socket.getProtocol()));
            }
        }
    }

    public void failure(Channel channel, ByteBuffer data, Exception e) {
    }

    public void connectionOpened(TCPChannel channel, boolean isReadyForWrites) {
        log.info(channel + " socket opened");
        FrontendSocketImpl socket = new FrontendSocketImpl(channel, ProtocolType.UNKNOWN, this.svrSocketInfo);
        channel.getSession().put((Object)FRONTEND_SOCKET, (Object)socket);
        this.http1_1Handler.socketOpened(socket, isReadyForWrites);
    }

    FrontendSocketImpl getSocket(Channel channel) {
        return (FrontendSocketImpl)channel.getSession().get((Object)FRONTEND_SOCKET);
    }

    public void setSvrSocketAddr(InetSocketAddress localAddr) {
        this.svrSocketInfo.setServerSocketAddress(localAddr);
    }
}

