/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.frontend2.impl;

import com.webpieces.hpack.api.dto.Http2Request;
import com.webpieces.http2engine.api.StreamWriter;
import com.webpieces.http2parser.api.dto.DataFrame;
import com.webpieces.http2parser.api.dto.lib.Http2Msg;
import com.webpieces.http2parser.api.dto.lib.StreamMsg;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicInteger;
import org.webpieces.data.api.DataWrapper;
import org.webpieces.data.api.DataWrapperGenerator;
import org.webpieces.data.api.DataWrapperGeneratorFactory;
import org.webpieces.frontend2.api.HttpStream;
import org.webpieces.frontend2.api.StreamListener;
import org.webpieces.frontend2.impl.FrontendSocketImpl;
import org.webpieces.frontend2.impl.Http1_1StreamImpl;
import org.webpieces.frontend2.impl.InitiationResult;
import org.webpieces.frontend2.impl.InitiationStatus;
import org.webpieces.http2translations.api.Http1_1ToHttp2;
import org.webpieces.httpparser.api.HttpParser;
import org.webpieces.httpparser.api.MarshalState;
import org.webpieces.httpparser.api.Memento;
import org.webpieces.httpparser.api.dto.HttpMessageType;
import org.webpieces.httpparser.api.dto.HttpPayload;
import org.webpieces.httpparser.api.dto.HttpRequest;
import org.webpieces.util.acking.AckAggregator;
import org.webpieces.util.acking.ByteAckTracker;
import org.webpieces.util.locking.PermitQueue;
import org.webpieces.util.logging.Logger;
import org.webpieces.util.logging.LoggerFactory;

public class Layer2Http1_1Handler {
    private static final Logger log = LoggerFactory.getLogger(Layer2Http1_1Handler.class);
    private static final DataWrapperGenerator dataGen = DataWrapperGeneratorFactory.createDataWrapperGenerator();
    private HttpParser httpParser;
    private StreamListener httpListener;
    private AtomicInteger counter = new AtomicInteger(1);
    private ByteAckTracker ackTracker = new ByteAckTracker();

    public Layer2Http1_1Handler(HttpParser httpParser, StreamListener httpListener) {
        this.httpParser = httpParser;
        this.httpListener = httpListener;
    }

    public InitiationResult initialData(FrontendSocketImpl socket, ByteBuffer buf) {
        return this.initialDataImpl(socket, buf);
    }

    public InitiationResult initialDataImpl(FrontendSocketImpl socket, ByteBuffer buf) {
        Memento state = socket.getHttp1_1ParseState();
        int newDataSize = buf.remaining();
        state = this.parse(socket, buf);
        int numBytesRead = state.getNumBytesJustParsed();
        InitiationResult result = this.checkForPreface(socket, state);
        if (result != null) {
            return result;
        }
        if (state.getParsedMessages().size() > 0) {
            this.processWithBackpressure(socket, newDataSize, numBytesRead).exceptionally(t -> this.logException((Throwable)t));
            return new InitiationResult(InitiationStatus.HTTP1_1);
        }
        this.ackTracker.createTracker(newDataSize, 0, numBytesRead);
        return null;
    }

    private Void logException(Throwable t) {
        log.error("exception", t);
        return null;
    }

    private InitiationResult checkForPreface(FrontendSocketImpl socket, Memento state) {
        if (state.getParsedMessages().size() != 1) {
            return null;
        }
        if (((HttpPayload)state.getParsedMessages().get(0)).getMessageType() != HttpMessageType.HTTP2_MARKER_MSG) {
            return null;
        }
        socket.setHttp1_1ParseState(null, null);
        return new InitiationResult(state.getLeftOverData(), InitiationStatus.PREFACE);
    }

    public CompletableFuture<Void> incomingData(FrontendSocketImpl socket, ByteBuffer buf) {
        Memento state = socket.getHttp1_1ParseState();
        int newDataSize = buf.remaining();
        state = this.parse(socket, buf);
        return this.processWithBackpressure(socket, newDataSize, state.getNumBytesJustParsed()).exceptionally(t -> {
            log.error("Exception", t);
            socket.close("Exception so closing http1.1 socket=" + t.getMessage());
            return null;
        });
    }

    public CompletableFuture<Void> processWithBackpressure(FrontendSocketImpl socket, int newDataSize, int numBytesRead) {
        Memento state = socket.getHttp1_1ParseState();
        List parsed = state.getParsedMessages();
        AckAggregator ack = this.ackTracker.createTracker(newDataSize, parsed.size(), numBytesRead);
        CompletionStage<Object> future = CompletableFuture.completedFuture(null);
        for (HttpPayload payload : parsed) {
            future = ((CompletableFuture)future.thenCompose(w -> this.processCorrectly(socket, payload))).handle((v, t) -> (Void)ack.ack(v, t));
        }
        return ack.getAckBytePayloadFuture();
    }

    private Memento parse(FrontendSocketImpl socket, ByteBuffer buf) {
        DataWrapper moreData = dataGen.wrapByteBuffer(buf);
        Memento state = socket.getHttp1_1ParseState();
        state = this.httpParser.parse(state, moreData);
        return state;
    }

    private CompletableFuture<Void> processCorrectly(FrontendSocketImpl socket, HttpPayload payload) {
        Http2Msg msg = Http1_1ToHttp2.translate((HttpPayload)payload, (boolean)socket.isHttps());
        if (payload instanceof HttpRequest) {
            return this.processInitialPieceOfRequest(socket, (HttpRequest)payload, (Http2Request)msg);
        }
        if (msg instanceof DataFrame) {
            return this.processData(socket, (DataFrame)msg);
        }
        throw new IllegalArgumentException("payload not supported=" + payload);
    }

    private CompletableFuture<Void> processData(FrontendSocketImpl socket, DataFrame msg) {
        PermitQueue permitQueue = socket.getPermitQueue();
        return permitQueue.runRequest(() -> {
            Http1_1StreamImpl stream = socket.getCurrentStream();
            StreamWriter requestWriter = stream.getRequestWriter();
            if (msg.isEndOfStream()) {
                stream.setSentFullRequest(true);
            }
            return requestWriter.processPiece((StreamMsg)msg).thenApply(v -> {
                stream.setRequestWriter(requestWriter);
                if (!msg.isEndOfStream()) {
                    permitQueue.releasePermit();
                }
                return null;
            });
        });
    }

    private CompletableFuture<Void> processInitialPieceOfRequest(FrontendSocketImpl socket, HttpRequest http1Req, Http2Request headers) {
        int id = this.counter.getAndAdd(2);
        PermitQueue permitQueue = socket.getPermitQueue();
        return permitQueue.runRequest(() -> {
            Http1_1StreamImpl currentStream = new Http1_1StreamImpl(id, socket, this.httpParser, permitQueue);
            HttpStream streamHandle = this.httpListener.openStream();
            currentStream.setStreamHandle(streamHandle);
            socket.setCurrentStream(currentStream);
            if (!headers.isEndOfStream()) {
                return streamHandle.incomingRequest(headers, currentStream).thenApply(w -> {
                    currentStream.setRequestWriter((StreamWriter)w);
                    permitQueue.releasePermit();
                    return null;
                });
            }
            currentStream.setSentFullRequest(true);
            return streamHandle.incomingRequest(headers, currentStream).thenApply(w -> {
                currentStream.setRequestWriter((StreamWriter)w);
                return null;
            });
        });
    }

    public void socketOpened(FrontendSocketImpl socket, boolean isReadyForWrites) {
        Memento parseState = this.httpParser.prepareToParse();
        MarshalState marshalState = this.httpParser.prepareToMarshal();
        socket.setHttp1_1ParseState(parseState, marshalState);
    }

    public void farEndClosed(FrontendSocketImpl socket) {
        socket.farEndClosed(this.httpListener);
    }
}

