/*
 * Decompiled with CFR 0.152.
 */
package com.webpieces.http2parser.api.dto;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public enum Http2Method {
    OPTIONS("OPTIONS"),
    GET("GET"),
    HEAD("HEAD"),
    POST("POST"),
    PUT("PUT"),
    DELETE("DELETE"),
    TRACE("TRACE"),
    CONNECT("CONNECT");

    private static Map<String, Http2Method> codeToKnownStatus;
    private String code;

    private Http2Method(String code) {
        this.code = code;
    }

    public String getCode() {
        return this.code;
    }

    public static Http2Method lookup(String method) {
        return codeToKnownStatus.get(method);
    }

    public static Set<Http2Method> getAll() {
        Collection<Http2Method> values = codeToKnownStatus.values();
        HashSet<Http2Method> methods = new HashSet<Http2Method>();
        methods.addAll(values);
        return methods;
    }

    static {
        codeToKnownStatus = new HashMap<String, Http2Method>();
        for (Http2Method status : Http2Method.values()) {
            codeToKnownStatus.put(status.getCode(), status);
        }
    }
}

