/*
 * Decompiled with CFR 0.152.
 */
package com.webpieces.http2parser.api.dto;

import com.webpieces.http2parser.api.dto.CancelReason;
import com.webpieces.http2parser.api.dto.lib.AbstractHttp2Frame;
import com.webpieces.http2parser.api.dto.lib.Http2ErrorCode;
import com.webpieces.http2parser.api.dto.lib.Http2FrameType;
import com.webpieces.http2parser.api.dto.lib.Http2MsgType;

public class RstStreamFrame
extends AbstractHttp2Frame
implements CancelReason {
    private long errorCode;

    public RstStreamFrame() {
    }

    public RstStreamFrame(int streamId, Http2ErrorCode code) {
        super(streamId);
        this.setKnownErrorCode(code);
    }

    public long getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(long errorCode) {
        this.errorCode = errorCode;
    }

    public Http2ErrorCode getKnownErrorCode() {
        return Http2ErrorCode.translate(this.errorCode);
    }

    public void setKnownErrorCode(Http2ErrorCode errorCode) {
        this.errorCode = errorCode.getCode();
    }

    @Override
    public Http2MsgType getMessageType() {
        return Http2MsgType.RST_STREAM;
    }

    @Override
    public Http2FrameType getFrameType() {
        return Http2FrameType.RST_STREAM;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (int)(this.errorCode ^ this.errorCode >>> 32);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RstStreamFrame other = (RstStreamFrame)obj;
        return this.errorCode == other.errorCode;
    }

    @Override
    public String toString() {
        return "RstStreamFrame{" + super.toString() + ", errorCode=" + this.errorCode + "} ";
    }
}

