/*
 * Decompiled with CFR 0.152.
 */
package com.webpieces.http2parser.api.dto;

import com.webpieces.http2parser.api.dto.lib.AbstractHttp2Frame;
import com.webpieces.http2parser.api.dto.lib.Http2FrameType;
import com.webpieces.http2parser.api.dto.lib.Http2MsgType;
import com.webpieces.http2parser.api.dto.lib.StreamMsg;
import org.webpieces.data.api.DataWrapper;

public class DataFrame
extends AbstractHttp2Frame
implements StreamMsg {
    private boolean endOfStream = true;
    private DataWrapper data = dataGen.emptyWrapper();
    private DataWrapper padding = dataGen.emptyWrapper();

    public DataFrame() {
    }

    public DataFrame(int streamId, boolean endOfStream) {
        this.streamId = streamId;
        this.endOfStream = endOfStream;
    }

    @Override
    public boolean isEndOfStream() {
        return this.endOfStream;
    }

    public void setEndOfStream(boolean endStream) {
        this.endOfStream = endStream;
    }

    public DataWrapper getData() {
        return this.data;
    }

    public void setData(DataWrapper data) {
        this.data = data;
    }

    public DataWrapper getPadding() {
        return this.padding;
    }

    public void setPadding(DataWrapper padding) {
        this.padding = padding;
    }

    @Override
    public Http2FrameType getFrameType() {
        return Http2FrameType.DATA;
    }

    @Override
    public Http2MsgType getMessageType() {
        return Http2MsgType.DATA;
    }

    @Override
    public String toString() {
        return "DataFrame{" + super.toString() + ", endStream=" + this.endOfStream + ", data.len=" + this.data.getReadableSize() + ", padding=" + this.padding.getReadableSize() + "}";
    }

    public long getTransmitFrameLength() {
        long len = this.data.getReadableSize();
        long padLen = this.padding.getReadableSize();
        if (padLen > 0L) {
            ++padLen;
        }
        return len + padLen;
    }
}

