/*
 * Decompiled with CFR 0.152.
 */
package com.webpieces.http2parser.impl;

import com.webpieces.http2parser.api.Padding;
import com.webpieces.http2parser.api.ParseException;
import com.webpieces.http2parser.api.dto.Http2ErrorCode;
import java.util.List;
import org.webpieces.data.api.DataWrapper;
import org.webpieces.data.api.DataWrapperGenerator;

public class PaddingImpl
implements Padding {
    private byte[] padding = null;
    private boolean padded = false;
    private final DataWrapperGenerator dataGen;

    public PaddingImpl(DataWrapperGenerator dataGen) {
        this.dataGen = dataGen;
    }

    @Override
    public void setPadding(byte[] padding) {
        this.padding = padding;
        this.padded = true;
    }

    @Override
    public boolean isPadded() {
        return this.padded;
    }

    @Override
    public void setIsPadded(boolean isPadded) {
        this.padded = isPadded;
    }

    @Override
    public byte[] getPadding() {
        return this.padding;
    }

    @Override
    public DataWrapper extractPayloadAndSetPaddingIfNeeded(DataWrapper data, int streamId) {
        if (this.isPadded()) {
            short padLength = (short)(data.readByteAt(0) & 0xFF);
            if (padLength > data.getReadableSize()) {
                throw new ParseException(Http2ErrorCode.PROTOCOL_ERROR, streamId, true);
            }
            List split1 = this.dataGen.split(data, 1);
            List split2 = this.dataGen.split((DataWrapper)split1.get(1), ((DataWrapper)split1.get(1)).getReadableSize() - padLength);
            this.setPadding(((DataWrapper)split2.get(1)).createByteArray());
            return (DataWrapper)split2.get(0);
        }
        return data;
    }

    @Override
    public DataWrapper padDataIfNeeded(DataWrapper data) {
        if (this.isPadded()) {
            byte[] length = new byte[]{(byte)this.padding.length};
            DataWrapper lengthDW = this.dataGen.wrapByteArray(length);
            DataWrapper paddingDW = this.dataGen.wrapByteArray(this.padding);
            return this.dataGen.chainDataWrappers(this.dataGen.chainDataWrappers(lengthDW, data), paddingDW);
        }
        return data;
    }
}

