/*
 * Decompiled with CFR 0.152.
 */
package com.webpieces.http2parser.impl;

import com.webpieces.http2parser.api.Http2Memento;
import com.webpieces.http2parser.api.Http2ParseException;
import com.webpieces.http2parser.api.Http2Parser;
import com.webpieces.http2parser.api.dto.UnknownFrame;
import com.webpieces.http2parser.api.dto.lib.AbstractHttp2Frame;
import com.webpieces.http2parser.api.dto.lib.Http2ErrorCode;
import com.webpieces.http2parser.api.dto.lib.Http2Frame;
import com.webpieces.http2parser.api.dto.lib.Http2FrameType;
import com.webpieces.http2parser.api.dto.lib.Http2Setting;
import com.webpieces.http2parser.impl.FrameHeaderData;
import com.webpieces.http2parser.impl.Http2MementoImpl;
import com.webpieces.http2parser.impl.ParsingState;
import com.webpieces.http2parser.impl.marshallers.ContinuationMarshaller;
import com.webpieces.http2parser.impl.marshallers.DataMarshaller;
import com.webpieces.http2parser.impl.marshallers.FrameMarshaller;
import com.webpieces.http2parser.impl.marshallers.GoAwayMarshaller;
import com.webpieces.http2parser.impl.marshallers.HeadersMarshaller;
import com.webpieces.http2parser.impl.marshallers.PingMarshaller;
import com.webpieces.http2parser.impl.marshallers.PriorityMarshaller;
import com.webpieces.http2parser.impl.marshallers.PushPromiseMarshaller;
import com.webpieces.http2parser.impl.marshallers.RstStreamMarshaller;
import com.webpieces.http2parser.impl.marshallers.SettingsMarshaller;
import com.webpieces.http2parser.impl.marshallers.WindowUpdateMarshaller;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.webpieces.data.api.BufferPool;
import org.webpieces.data.api.DataWrapper;
import org.webpieces.data.api.DataWrapperGenerator;
import org.webpieces.data.api.DataWrapperGeneratorFactory;

public class Http2ParserImpl
implements Http2Parser {
    private final DataWrapperGenerator dataGen = DataWrapperGeneratorFactory.createDataWrapperGenerator();
    private final Map<Http2FrameType, FrameMarshaller> dtoToMarshaller = new HashMap<Http2FrameType, FrameMarshaller>();
    private BufferPool bufferPool;
    private SettingsMarshaller settingsMarshaller;

    public Http2ParserImpl(BufferPool bufferPool) {
        this.bufferPool = bufferPool;
        this.settingsMarshaller = new SettingsMarshaller(bufferPool, this.dataGen);
        this.dtoToMarshaller.put(Http2FrameType.CONTINUATION, new ContinuationMarshaller(bufferPool, this.dataGen));
        this.dtoToMarshaller.put(Http2FrameType.DATA, new DataMarshaller(bufferPool, this.dataGen));
        this.dtoToMarshaller.put(Http2FrameType.GOAWAY, new GoAwayMarshaller(bufferPool, this.dataGen));
        this.dtoToMarshaller.put(Http2FrameType.HEADERS, new HeadersMarshaller(bufferPool, this.dataGen));
        this.dtoToMarshaller.put(Http2FrameType.PING, new PingMarshaller(bufferPool, this.dataGen));
        this.dtoToMarshaller.put(Http2FrameType.PRIORITY, new PriorityMarshaller(bufferPool, this.dataGen));
        this.dtoToMarshaller.put(Http2FrameType.PUSH_PROMISE, new PushPromiseMarshaller(bufferPool, this.dataGen));
        this.dtoToMarshaller.put(Http2FrameType.RST_STREAM, new RstStreamMarshaller(bufferPool, this.dataGen));
        this.dtoToMarshaller.put(Http2FrameType.SETTINGS, this.settingsMarshaller);
        this.dtoToMarshaller.put(Http2FrameType.WINDOW_UPDATE, new WindowUpdateMarshaller(bufferPool, this.dataGen));
    }

    @Override
    public Http2Memento prepareToParse(long maxFrameSize) {
        return new Http2MementoImpl(this.dataGen.emptyWrapper(), maxFrameSize);
    }

    @Override
    public Http2Memento parse(Http2Memento memento, DataWrapper newData) {
        Http2MementoImpl state = (Http2MementoImpl)memento;
        state.getParsedFrames().clear();
        DataWrapper allData = this.dataGen.chainDataWrappers(state.getLeftOverData(), newData);
        state.setLeftOverData(allData);
        while (true) {
            switch (state.getParsingState()) {
                case NEED_PARSE_FRAME_HEADER: {
                    if (!this.parseFrameHeader(state)) {
                        return state;
                    }
                    state.setParsingState(ParsingState.NEED_PARSE_BODY);
                    break;
                }
                case NEED_PARSE_BODY: {
                    if (!this.parseBody(state)) {
                        return state;
                    }
                    state.setParsingState(ParsingState.NEED_PARSE_FRAME_HEADER);
                }
            }
        }
    }

    private boolean parseBody(Http2MementoImpl state) {
        AbstractHttp2Frame frame;
        DataWrapper allData = state.getLeftOverData();
        FrameHeaderData headerData = state.getFrameHeaderData();
        if (headerData == null) {
            throw new IllegalArgumentException("Bug, this should never be null at this point");
        }
        int payloadLen = headerData.getPayloadLength();
        if (allData.getReadableSize() < payloadLen) {
            return false;
        }
        List split = this.dataGen.split(allData, payloadLen);
        DataWrapper framePayloadData = (DataWrapper)split.get(0);
        Optional<Http2FrameType> optFrameType = Http2FrameType.fromId(headerData.getFrameTypeId());
        if (optFrameType.isPresent()) {
            Http2FrameType frameType = optFrameType.get();
            FrameMarshaller marshaller = this.dtoToMarshaller.get((Object)frameType);
            if (marshaller == null) {
                throw new IllegalArgumentException("bug, our developer forgot to add marshaller and only added the enum=" + (Object)((Object)frameType));
            }
            frame = marshaller.unmarshal(state, framePayloadData);
        } else {
            frame = new UnknownFrame(headerData.getFlagsByte(), headerData.getFrameTypeId(), headerData.getStreamId(), framePayloadData);
        }
        state.setFrameHeaderData(null);
        state.setLeftOverData((DataWrapper)split.get(1));
        state.addParsedFrame(frame);
        return true;
    }

    private boolean parseFrameHeader(Http2MementoImpl state) {
        DataWrapper allData = state.getLeftOverData();
        int lengthOfData = allData.getReadableSize();
        if (lengthOfData < 9) {
            state.setLeftOverData(allData);
            return false;
        }
        List split = this.dataGen.split(allData, 9);
        DataWrapper frameHeader = (DataWrapper)split.get(0);
        DataWrapper left = (DataWrapper)split.get(1);
        int payloadLength = this.getLength(frameHeader);
        int streamId = this.getStreamId(frameHeader);
        byte frameTypeId = frameHeader.readByteAt(3);
        byte flagsByte = frameHeader.readByteAt(4);
        long maxFrameSize = state.getIncomingMaxFrameSize();
        if ((long)payloadLength > maxFrameSize) {
            throw new Http2ParseException(Http2ErrorCode.FRAME_SIZE_ERROR, streamId, "Frame size=" + payloadLength + " was greater than max=" + maxFrameSize, true);
        }
        state.setFrameHeaderData(new FrameHeaderData(payloadLength, streamId, frameTypeId, flagsByte));
        state.setLeftOverData(left);
        return true;
    }

    private int getLength(DataWrapper data) {
        ByteBuffer headerByteBuffer = this.bufferPool.nextBuffer(9);
        headerByteBuffer.put(data.readBytesAt(0, 9));
        headerByteBuffer.flip();
        return headerByteBuffer.getInt() >>> 8;
    }

    private int getStreamId(DataWrapper data) {
        ByteBuffer streamIdBuffer = this.bufferPool.nextBuffer(4);
        streamIdBuffer.put(data.readBytesAt(5, 4));
        streamIdBuffer.flip();
        return streamIdBuffer.getInt() & Integer.MAX_VALUE;
    }

    @Override
    public DataWrapper marshal(Http2Frame frame) {
        Http2FrameType frameType = frame.getFrameType();
        FrameMarshaller marshaller = this.dtoToMarshaller.get((Object)frameType);
        if (marshaller == null) {
            throw new IllegalArgumentException("unknown frame bean=" + frame);
        }
        return marshaller.marshal(frame);
    }

    @Override
    public List<Http2Setting> unmarshalSettingsPayload(String base64SettingsPayload) {
        return this.settingsMarshaller.unmarshalPayload(base64SettingsPayload);
    }

    @Override
    public String marshalSettingsPayload(List<Http2Setting> settingsPayload) {
        return this.settingsMarshaller.marshalPayload(settingsPayload);
    }
}

