/*
 * Decompiled with CFR 0.152.
 */
package com.webpieces.http2parser.api;

import com.webpieces.http2parser.api.ErrorType;
import com.webpieces.http2parser.api.ParseFailReason;

public abstract class Http2Exception
extends RuntimeException {
    private static final long serialVersionUID = -2704718008204232741L;
    private int streamId = 0;
    private ParseFailReason reason;

    public Http2Exception(ParseFailReason reason, int streamId, String msg) {
        super(msg + " reason=" + (Object)((Object)reason) + " stream=" + streamId);
        this.reason = reason;
        this.streamId = streamId;
    }

    public Http2Exception(ParseFailReason reason, int streamId, String msg, Throwable e) {
        super(msg + " reason=" + (Object)((Object)reason) + " stream=" + streamId, e);
        this.reason = reason;
        this.streamId = streamId;
    }

    public int getStreamId() {
        return this.streamId;
    }

    public boolean hasStream() {
        return this.streamId == 0;
    }

    public ParseFailReason getReason() {
        return this.reason;
    }

    public abstract ErrorType getErrorType();
}

