/*
 * Decompiled with CFR 0.152.
 */
package com.webpieces.http2parser.impl.marshallers;

import com.webpieces.http2parser.api.dto.HeadersFrame;
import com.webpieces.http2parser.api.dto.error.CancelReasonCode;
import com.webpieces.http2parser.api.dto.error.ConnectionException;
import com.webpieces.http2parser.api.dto.lib.AbstractHttp2Frame;
import com.webpieces.http2parser.api.dto.lib.Http2Frame;
import com.webpieces.http2parser.api.dto.lib.PriorityDetails;
import com.webpieces.http2parser.impl.DataSplit;
import com.webpieces.http2parser.impl.Http2MementoImpl;
import com.webpieces.http2parser.impl.PaddingUtil;
import com.webpieces.http2parser.impl.marshallers.AbstractFrameMarshaller;
import com.webpieces.http2parser.impl.marshallers.FrameMarshaller;
import com.webpieces.http2parser.impl.marshallers.PriorityMarshaller;
import java.nio.ByteBuffer;
import java.util.List;
import org.webpieces.data.api.BufferPool;
import org.webpieces.data.api.DataWrapper;
import org.webpieces.data.api.DataWrapperGenerator;

public class HeadersMarshaller
extends AbstractFrameMarshaller
implements FrameMarshaller {
    public HeadersMarshaller(BufferPool bufferPool, DataWrapperGenerator dataGen) {
        super(bufferPool);
    }

    @Override
    public DataWrapper marshal(Http2Frame frame) {
        PriorityDetails priorityDetails;
        HeadersFrame castFrame = (HeadersFrame)frame;
        if (frame.getStreamId() == 0) {
            throw new ConnectionException(CancelReasonCode.INVALID_STREAM_ID, frame.getStreamId(), "Headers frame cannot be streamId 0");
        }
        int paddingSize = castFrame.getPadding().getReadableSize();
        byte value = 0;
        if (castFrame.isEndOfStream()) {
            value = (byte)(value | 1);
        }
        if (castFrame.isEndHeaders()) {
            value = (byte)(value | 4);
        }
        if (paddingSize > 0) {
            value = (byte)(value | 8);
        }
        if (castFrame.isPriority()) {
            value = (byte)(value | 0x20);
        }
        DataWrapper preludeDW = (priorityDetails = castFrame.getPriorityDetails()) != null ? PriorityMarshaller.marshalPriorityDetails(this.bufferPool, priorityDetails, frame) : dataGen.emptyWrapper();
        DataWrapper unpadded = dataGen.chainDataWrappers(preludeDW, castFrame.getHeaderFragment());
        DataWrapper payload = PaddingUtil.padDataIfNeeded(unpadded, castFrame.getPadding());
        return super.marshalFrame(frame, value, payload);
    }

    @Override
    public AbstractHttp2Frame unmarshal(Http2MementoImpl state, DataWrapper framePayloadData) {
        HeadersFrame frame = new HeadersFrame();
        super.unmarshalFrame(state, frame);
        byte flagsByte = state.getFrameHeaderData().getFlagsByte();
        frame.setEndOfStream((flagsByte & 1) == 1);
        frame.setEndHeaders((flagsByte & 4) == 4);
        boolean isPadded = (flagsByte & 8) == 8;
        PriorityDetails priorityDetails = null;
        if ((flagsByte & 0x20) == 32) {
            priorityDetails = new PriorityDetails();
            frame.setPriorityDetails(priorityDetails);
        }
        DataSplit padSplit = PaddingUtil.extractPayloadAndPadding(isPadded, framePayloadData, frame.getStreamId());
        frame.setPadding(padSplit.getPadding());
        DataWrapper paddingStripped = padSplit.getPayload();
        if (priorityDetails != null) {
            List split = dataGen.split(paddingStripped, 5);
            ByteBuffer preludeBytes = this.bufferPool.createWithDataWrapper((DataWrapper)split.get(0));
            int firstInt = preludeBytes.getInt();
            priorityDetails.setStreamDependencyIsExclusive(firstInt >>> 31 == 1);
            int streamDependency = firstInt & Integer.MAX_VALUE;
            if (streamDependency == frame.getStreamId()) {
                throw new ConnectionException(CancelReasonCode.BAD_STREAM_DEPENDENCY, streamDependency, "stream id=" + streamDependency + " depends on itself");
            }
            priorityDetails.setStreamDependency(streamDependency);
            priorityDetails.setWeight((short)(preludeBytes.get() & 0xFF));
            frame.setHeaderFragment((DataWrapper)split.get(1));
            this.bufferPool.releaseBuffer(preludeBytes);
        } else {
            frame.setHeaderFragment(paddingStripped);
        }
        if (frame.getStreamId() == 0) {
            throw new ConnectionException(CancelReasonCode.INVALID_STREAM_ID, frame.getStreamId(), "headers frame had invalid stream id=" + frame.getStreamId());
        }
        return frame;
    }
}

