/*
 * Decompiled with CFR 0.152.
 */
package com.webpieces.http2parser.api.dto.lib;

import java.util.HashMap;
import java.util.Map;

public enum Http2ErrorCode {
    NO_ERROR(0L),
    PROTOCOL_ERROR(1L),
    INTERNAL_ERROR(2L),
    FLOW_CONTROL_ERROR(3L),
    SETTINGS_TIMEOUT(4L),
    STREAM_CLOSED(5L),
    FRAME_SIZE_ERROR(6L),
    REFUSED_STREAM(7L),
    CANCEL(8L),
    COMPRESSION_ERROR(9L),
    CONNECT_ERROR(10L),
    ENHANCE_YOUR_CALM(11L),
    INADEQUATE_SECURITY(12L),
    HTTP_1_1_REQUIRED(13L);

    private static final Map<Long, Http2ErrorCode> codeToError;
    private long code;

    private Http2ErrorCode(long code) {
        this.code = code;
    }

    public long getCode() {
        return this.code;
    }

    public static Http2ErrorCode translate(long code) {
        Http2ErrorCode http2ErrorCode = codeToError.get(code);
        if (http2ErrorCode == null) {
            throw new IllegalArgumentException("code=" + code + " is not known");
        }
        return http2ErrorCode;
    }

    static {
        codeToError = new HashMap<Long, Http2ErrorCode>();
        for (Http2ErrorCode c : Http2ErrorCode.values()) {
            codeToError.put(c.getCode(), c);
        }
    }
}

