/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.platform.mbean;

import java.lang.management.ManagementFactory;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.platform.mbean.AbstractPlatformMBeanAttributeHandler;
import org.jboss.as.platform.mbean.OperatingSystemResourceDefinition;
import org.jboss.as.platform.mbean.PlatformMBeanConstants;
import org.jboss.as.platform.mbean.PlatformMBeanMessages;
import org.jboss.as.platform.mbean.PlatformMBeanUtil;
import org.jboss.dmr.ModelNode;

class OperatingSystemMXBeanAttributeHandler
extends AbstractPlatformMBeanAttributeHandler {
    static final OperatingSystemMXBeanAttributeHandler INSTANCE = new OperatingSystemMXBeanAttributeHandler();

    private OperatingSystemMXBeanAttributeHandler() {
    }

    @Override
    protected void executeReadAttribute(OperationContext context, ModelNode operation) throws OperationFailedException {
        String name = operation.require("name").asString();
        try {
            if (!(PlatformMBeanUtil.JVM_MAJOR_VERSION > 6 && PlatformMBeanConstants.OBJECT_NAME.getName().equals(name) || OperatingSystemResourceDefinition.OPERATING_SYSTEM_READ_ATTRIBUTES.contains(name) || OperatingSystemResourceDefinition.OPERATING_SYSTEM_METRICS.contains(name))) {
                throw OperatingSystemMXBeanAttributeHandler.unknownAttribute(operation);
            }
            OperatingSystemMXBeanAttributeHandler.storeResult(name, context.getResult());
        }
        catch (SecurityException e) {
            throw new OperationFailedException(new ModelNode().set(e.toString()));
        }
    }

    @Override
    protected void executeWriteAttribute(OperationContext context, ModelNode operation) throws OperationFailedException {
        throw OperatingSystemMXBeanAttributeHandler.unknownAttribute(operation);
    }

    static void storeResult(String name, ModelNode store) {
        if (PlatformMBeanUtil.JVM_MAJOR_VERSION > 6 && PlatformMBeanConstants.OBJECT_NAME.getName().equals(name)) {
            store.set("java.lang:type=OperatingSystem");
        } else if ("name".equals(name)) {
            store.set(ManagementFactory.getOperatingSystemMXBean().getName());
        } else if ("arch".equals(name)) {
            store.set(ManagementFactory.getOperatingSystemMXBean().getArch());
        } else if ("version".equals(name)) {
            store.set(ManagementFactory.getOperatingSystemMXBean().getVersion());
        } else if ("available-processors".equals(name)) {
            store.set(ManagementFactory.getOperatingSystemMXBean().getAvailableProcessors());
        } else if ("system-load-average".equals(name)) {
            store.set(ManagementFactory.getOperatingSystemMXBean().getSystemLoadAverage());
        } else if (OperatingSystemResourceDefinition.OPERATING_SYSTEM_READ_ATTRIBUTES.contains(name) || OperatingSystemResourceDefinition.OPERATING_SYSTEM_METRICS.contains(name)) {
            throw PlatformMBeanMessages.MESSAGES.badReadAttributeImpl8(name);
        }
    }
}

