/*
 * Decompiled with CFR 0.152.
 */
package ext.deployit.community.plugin.lock;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.plugin.api.deployment.planning.Contributor;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.Deltas;
import com.xebialabs.deployit.plugin.api.deployment.specification.Operation;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.api.udm.DeployedApplication;
import com.xebialabs.deployit.plugin.api.udm.Environment;
import ext.deployit.community.plugin.lock.AcquireAllLocksStep;
import ext.deployit.community.plugin.lock.LockHelper;
import java.util.HashSet;
import java.util.Set;

public class DeploymentLockContributor {
    private static final String CONCURRENT_DEPLOYMENTS_ALLOWED_PROPERTY = "allowConcurrentDeployments";

    @Contributor
    public void addDeploymentLockCheckStep(Deltas deltas, DeploymentPlanningContext ctx) {
        DeployedApplication deployedApplication = ctx.getDeployedApplication();
        Environment environment = deployedApplication.getEnvironment();
        HashSet<ConfigurationItem> cisToBeLocked = new HashSet<ConfigurationItem>();
        if (this.shouldLockCI((ConfigurationItem)deployedApplication)) {
            cisToBeLocked.add((ConfigurationItem)deployedApplication);
        }
        if (this.shouldLockCI((ConfigurationItem)environment)) {
            cisToBeLocked.add((ConfigurationItem)environment);
        }
        cisToBeLocked.addAll(this.getContainersRequiringCheck(deltas));
        if (!cisToBeLocked.isEmpty()) {
            ctx.addStep((Step)new AcquireAllLocksStep(new LockHelper(), cisToBeLocked));
        }
    }

    private boolean shouldLockCI(ConfigurationItem ci) {
        return ci.hasProperty(CONCURRENT_DEPLOYMENTS_ALLOWED_PROPERTY) && Boolean.FALSE.equals(ci.getProperty(CONCURRENT_DEPLOYMENTS_ALLOWED_PROPERTY));
    }

    private Set<Container> getContainersRequiringCheck(Deltas deltas) {
        Iterable containersInAction = Iterables.transform((Iterable)deltas.getDeltas(), (Function)new Function<Delta, Container>(){

            public Container apply(Delta input) {
                return input.getOperation() == Operation.DESTROY ? input.getPrevious().getContainer() : input.getDeployed().getContainer();
            }
        });
        HashSet containers = Sets.newHashSet((Iterable)Iterables.filter((Iterable)containersInAction, (Predicate)new Predicate<Container>(){

            public boolean apply(Container input) {
                return Boolean.FALSE.equals(input.getProperty(DeploymentLockContributor.CONCURRENT_DEPLOYMENTS_ALLOWED_PROPERTY));
            }
        }));
        return containers;
    }
}

