/*
 * Decompiled with CFR 0.152.
 */
package ext.deployit.community.plugin.personalcredentials.contributor;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.plugin.api.deployment.planning.PrePlanProcessor;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.DeltaSpecification;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.api.udm.DeployedApplication;
import com.xebialabs.deployit.plugin.api.udm.Environment;
import com.xebialabs.deployit.plugin.overthere.Host;
import com.xebialabs.deployit.plugin.overthere.HostContainer;
import com.xebialabs.deployit.plugin.overthere.step.CheckConnectionStep;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdentityContributor {
    private static final Function<Delta, Host> DEPLOYED_TO_HOST = new ToHost(){

        public Host apply(Delta input) {
            return this.toHost(input.getDeployed());
        }
    };
    private static final Function<Delta, Host> PREVIOUS_TO_HOST = new ToHost(){

        public Host apply(Delta input) {
            return this.toHost(input.getPrevious());
        }
    };
    protected static final Logger logger = LoggerFactory.getLogger(IdentityContributor.class);

    @PrePlanProcessor
    public List<Step> injectPersonalCredentials(DeltaSpecification specification) {
        List deltas = specification.getDeltas();
        final DeployedApplication deployedApplication = specification.getDeployedApplication();
        Environment environment = deployedApplication.getEnvironment();
        Boolean override = (Boolean)environment.getProperty("overrideHostCredentials");
        if (!override.booleanValue()) {
            return null;
        }
        ImmutableSet hosts = ImmutableSet.builder().addAll(Iterables.filter((Iterable)Iterables.transform((Iterable)deltas, DEPLOYED_TO_HOST), (Predicate)Predicates.notNull())).addAll(Iterables.filter((Iterable)Iterables.transform((Iterable)deltas, PREVIOUS_TO_HOST), (Predicate)Predicates.notNull())).build();
        logger.debug("Hosts {}", (Object)hosts);
        final Boolean perOsCredential = this.isPerOsCredential(deployedApplication);
        Iterable transform = Iterables.transform((Iterable)hosts, (Function)new Function<Host, Step>(){

            public Step apply(Host host) {
                if (perOsCredential.booleanValue()) {
                    switch (host.getOs()) {
                        case WINDOWS: {
                            logger.debug("IdentityContributor injects credentials in a {} host {}", (Object)"WINDOWS", (Object)host.getId());
                            this.setCredentials(host, "windowsUsername", "windowsPassword");
                            break;
                        }
                        case UNIX: {
                            logger.debug("IdentityContributor injects credentials in a {} host {}", (Object)"UNIX", (Object)host.getId());
                            this.setCredentials(host, "unixUsername", "unixPassword");
                        }
                    }
                } else {
                    logger.debug("IdentityContributor injects credentials in a host {} ", (Object)host.getId());
                    this.setCredentials(host, "username", "password");
                }
                if (!deployedApplication.hasProperty("checkConnection")) {
                    return null;
                }
                Boolean checkConnection = (Boolean)deployedApplication.getProperty("checkConnection");
                return checkConnection != false ? new CheckConnectionStep(host) : null;
            }

            private void setCredentials(Host host, String usernamePropertyName, String passwordPropertyName) {
                String username = (String)deployedApplication.getProperty(usernamePropertyName);
                String password = (String)deployedApplication.getProperty(passwordPropertyName);
                if (Strings.isNullOrEmpty((String)username) || Strings.isNullOrEmpty((String)password)) {
                    Descriptor descriptor = deployedApplication.getType().getDescriptor();
                    String usernameLabel = descriptor.getPropertyDescriptor(usernamePropertyName).getLabel();
                    String passwordLabel = descriptor.getPropertyDescriptor(passwordPropertyName).getLabel();
                    throw new RuntimeException(String.format("Cannot find personal credentials for host (%s/%s), please provide values for the '%s' and '%s' properties", host.getId(), host.getOs().toString(), usernameLabel, passwordLabel));
                }
                host.setProperty("username", (Object)username);
                host.setProperty("password", (Object)password);
            }
        });
        return Lists.newArrayList((Iterable)Iterables.filter((Iterable)transform, (Predicate)Predicates.notNull()));
    }

    private Boolean isPerOsCredential(DeployedApplication deployedApplication) {
        if (deployedApplication.hasProperty("unixUsername") && deployedApplication.hasProperty("unixPassword") && deployedApplication.hasProperty("windowsUsername") && deployedApplication.hasProperty("windowsPassword")) {
            return true;
        }
        if (deployedApplication.hasProperty("username") && deployedApplication.hasProperty("password")) {
            return false;
        }
        throw new RuntimeException("Invalid configuration on udm.DeployedApplication for personal-credentials plugin, either set 'username' & 'password' properties or , either set 'unixUsername' & 'unixPassword' & 'windowsUsername' & 'windowsPassword' properties.");
    }

    static abstract class ToHost
    implements Function<Delta, Host> {
        ToHost() {
        }

        protected Host toHost(Deployed<?, ?> deployed) {
            if (deployed == null) {
                return null;
            }
            return this.toHost((ConfigurationItem)deployed.getContainer());
        }

        private Host toHost(ConfigurationItem item) {
            if (item instanceof Host) {
                return (Host)item;
            }
            if (item instanceof HostContainer) {
                HostContainer hostContainer = (HostContainer)item;
                return hostContainer.getHost();
            }
            Collection propertyDescriptors = item.getType().getDescriptor().getPropertyDescriptors();
            for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
                Host host;
                if (propertyDescriptor.getReferencedType() == null || !propertyDescriptor.getReferencedType().instanceOf(Type.valueOf(Host.class)) && !propertyDescriptor.isAsContainment() || (host = this.toHost((ConfigurationItem)propertyDescriptor.get(item))) == null) continue;
                return host;
            }
            return null;
        }
    }
}

