/*
 * Decompiled with CFR 0.152.
 */
package org.xmlunit.placeholder;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.xmlunit.XMLUnitException;
import org.xmlunit.diff.ComparisonResult;
import org.xmlunit.placeholder.PlaceholderHandler;

public class MatchesRegexPlaceholderHandler
implements PlaceholderHandler {
    private static final String PLACEHOLDER_NAME = "matchesRegex";

    @Override
    public String getKeyword() {
        return PLACEHOLDER_NAME;
    }

    @Override
    public ComparisonResult evaluate(String testText, String ... param) {
        if (param.length > 0 && param[0] != null && !param[0].equals("")) {
            try {
                Pattern pattern = Pattern.compile(param[0].trim());
                if (testText != null && this.evaluate(testText.trim(), pattern)) {
                    return ComparisonResult.EQUAL;
                }
            }
            catch (PatternSyntaxException e) {
                throw new XMLUnitException(e.getMessage(), (Throwable)e);
            }
        }
        return ComparisonResult.DIFFERENT;
    }

    private boolean evaluate(String testText, Pattern pattern) {
        return pattern.matcher(testText).find();
    }
}

