/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.problem.violations;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.concurrent.Immutable;
import org.apiguardian.api.API;
import org.zalando.problem.StatusType;
import org.zalando.problem.ThrowableProblem;
import org.zalando.problem.violations.Violation;

@API(status=API.Status.STABLE)
@Immutable
public class ConstraintViolationProblem
extends ThrowableProblem {
    public static final String TYPE_VALUE = "https://zalando.github.io/problem/constraint-violation";
    public static final URI TYPE = URI.create("https://zalando.github.io/problem/constraint-violation");
    private final URI type;
    private final StatusType status;
    private final List<Violation> violations;

    public ConstraintViolationProblem(StatusType status, List<Violation> violations) {
        this(TYPE, status, violations != null ? new ArrayList<Violation>(violations) : new ArrayList());
    }

    public ConstraintViolationProblem(URI type, StatusType status, List<Violation> violations) {
        this.type = type;
        this.status = status;
        this.violations = violations != null ? Collections.unmodifiableList(violations) : Collections.emptyList();
    }

    public URI getType() {
        return this.type;
    }

    public String getTitle() {
        return "Constraint Violation";
    }

    public StatusType getStatus() {
        return this.status;
    }

    public List<Violation> getViolations() {
        return this.violations;
    }
}

