/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.problem;

import java.net.URI;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apiguardian.api.API;
import org.zalando.problem.DefaultProblem;
import org.zalando.problem.StatusType;
import org.zalando.problem.ThrowableProblem;

@API(status=API.Status.STABLE)
public final class ProblemBuilder {
    private static final Set<String> RESERVED_PROPERTIES = new HashSet<String>(Arrays.asList("type", "title", "status", "detail", "instance", "cause"));
    private URI type;
    private String title;
    private StatusType status;
    private String detail;
    private URI instance;
    private ThrowableProblem cause;
    private final Map<String, Object> parameters = new LinkedHashMap<String, Object>();

    ProblemBuilder() {
    }

    public ProblemBuilder withType(@Nullable URI type) {
        this.type = type;
        return this;
    }

    public ProblemBuilder withTitle(@Nullable String title) {
        this.title = title;
        return this;
    }

    public ProblemBuilder withStatus(@Nullable StatusType status) {
        this.status = status;
        return this;
    }

    public ProblemBuilder withDetail(@Nullable String detail) {
        this.detail = detail;
        return this;
    }

    public ProblemBuilder withInstance(@Nullable URI instance) {
        this.instance = instance;
        return this;
    }

    public ProblemBuilder withCause(@Nullable ThrowableProblem cause) {
        this.cause = cause;
        return this;
    }

    public ProblemBuilder with(String key, Object value) throws IllegalArgumentException {
        if (RESERVED_PROPERTIES.contains(key)) {
            throw new IllegalArgumentException("Property " + key + " is reserved");
        }
        this.parameters.put(key, value);
        return this;
    }

    public ThrowableProblem build() {
        return new DefaultProblem(this.type, this.title, this.status, this.detail, this.instance, this.cause, new LinkedHashMap<String, Object>(this.parameters));
    }
}

