/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.exec.close;

import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zeroturnaround.exec.close.ProcessCloser;
import org.zeroturnaround.exec.stream.ExecuteStreamHandler;

public class StandardProcessCloser
implements ProcessCloser {
    private static final Logger log = LoggerFactory.getLogger(StandardProcessCloser.class);
    protected final ExecuteStreamHandler streams;

    public StandardProcessCloser(ExecuteStreamHandler streams) {
        this.streams = streams;
    }

    public void close(Process process) throws IOException, InterruptedException {
        if (this.streams != null) {
            this.streams.stop();
        }
        this.closeStreams(process);
    }

    private void closeStreams(Process process) throws IOException {
        IOException caught = null;
        try {
            process.getOutputStream().close();
        }
        catch (IOException e) {
            log.error("Failed to close process output stream:", (Throwable)e);
            caught = e;
        }
        try {
            process.getInputStream().close();
        }
        catch (IOException e) {
            log.error("Failed to close process input stream:", (Throwable)e);
            caught = e;
        }
        try {
            process.getErrorStream().close();
        }
        catch (IOException e) {
            log.error("Failed to close process error stream:", (Throwable)e);
            caught = e;
        }
        if (caught != null) {
            throw caught;
        }
    }
}

