/*
 * Decompiled with CFR 0.152.
 */
package pl.droidsonroids.gif;

import android.content.ContentResolver;
import android.content.res.AssetFileDescriptor;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.net.Uri;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.DrawableRes;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RawRes;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Locale;
import pl.droidsonroids.gif.GifDrawable;
import pl.droidsonroids.gif.GifInfoHandle;
import pl.droidsonroids.gif.annotations.Beta;

public class GifAnimationMetaData
implements Serializable,
Parcelable {
    private static final long serialVersionUID = 5692363926580237325L;
    private final int mLoopCount;
    private final int mDuration;
    private final int mHeight;
    private final int mWidth;
    private final int mImageCount;
    private final long mPixelsBytesCount;
    private final long mMetadataBytesCount;
    public static final Parcelable.Creator<GifAnimationMetaData> CREATOR = new Parcelable.Creator<GifAnimationMetaData>(){

        public GifAnimationMetaData createFromParcel(Parcel source) {
            return new GifAnimationMetaData(source);
        }

        public GifAnimationMetaData[] newArray(int size) {
            return new GifAnimationMetaData[size];
        }
    };

    public GifAnimationMetaData(@NonNull Resources res, @RawRes @DrawableRes int id) throws Resources.NotFoundException, IOException {
        this(res.openRawResourceFd(id));
    }

    public GifAnimationMetaData(@NonNull AssetManager assets, @NonNull String assetName) throws IOException {
        this(assets.openFd(assetName));
    }

    public GifAnimationMetaData(@NonNull String filePath) throws IOException {
        this(new GifInfoHandle(filePath));
    }

    public GifAnimationMetaData(@NonNull File file) throws IOException {
        this(file.getPath());
    }

    public GifAnimationMetaData(@NonNull InputStream stream) throws IOException {
        this(new GifInfoHandle(stream));
    }

    public GifAnimationMetaData(@NonNull AssetFileDescriptor afd) throws IOException {
        this(new GifInfoHandle(afd));
    }

    public GifAnimationMetaData(@NonNull FileDescriptor fd) throws IOException {
        this(new GifInfoHandle(fd));
    }

    public GifAnimationMetaData(@NonNull byte[] bytes) throws IOException {
        this(new GifInfoHandle(bytes));
    }

    public GifAnimationMetaData(@NonNull ByteBuffer buffer) throws IOException {
        this(new GifInfoHandle(buffer));
    }

    public GifAnimationMetaData(@Nullable ContentResolver resolver, @NonNull Uri uri) throws IOException {
        this(GifInfoHandle.openUri(resolver, uri));
    }

    private GifAnimationMetaData(GifInfoHandle gifInfoHandle) {
        this.mLoopCount = gifInfoHandle.getLoopCount();
        this.mDuration = gifInfoHandle.getDuration();
        this.mWidth = gifInfoHandle.getWidth();
        this.mHeight = gifInfoHandle.getHeight();
        this.mImageCount = gifInfoHandle.getNumberOfFrames();
        this.mMetadataBytesCount = gifInfoHandle.getMetadataByteCount();
        this.mPixelsBytesCount = gifInfoHandle.getAllocationByteCount();
        gifInfoHandle.recycle();
    }

    public int getWidth() {
        return this.mWidth;
    }

    public int getHeight() {
        return this.mHeight;
    }

    public int getNumberOfFrames() {
        return this.mImageCount;
    }

    public int getLoopCount() {
        return this.mLoopCount;
    }

    public int getDuration() {
        return this.mDuration;
    }

    public boolean isAnimated() {
        return this.mImageCount > 1 && this.mDuration > 0;
    }

    public long getAllocationByteCount() {
        return this.mPixelsBytesCount;
    }

    @Beta
    public long getDrawableAllocationByteCount(@Nullable GifDrawable oldDrawable, @IntRange(from=1L, to=65535L) int sampleSize) {
        if (sampleSize < 1 || sampleSize > 65535) {
            throw new IllegalStateException("Sample size " + sampleSize + " out of range <1, " + '\uffff' + ">");
        }
        int sampleSizeFactor = sampleSize * sampleSize;
        long bufferSize = oldDrawable != null && !oldDrawable.mBuffer.isRecycled() ? (Build.VERSION.SDK_INT >= 19 ? (long)oldDrawable.mBuffer.getAllocationByteCount() : (long)oldDrawable.getFrameByteCount()) : (long)(this.mWidth * this.mHeight * 4 / sampleSizeFactor);
        return this.mPixelsBytesCount / (long)sampleSizeFactor + bufferSize;
    }

    public long getMetadataAllocationByteCount() {
        return this.mMetadataBytesCount;
    }

    @NonNull
    public String toString() {
        String loopCount = this.mLoopCount == 0 ? "Infinity" : Integer.toString(this.mLoopCount);
        String suffix = String.format(Locale.ENGLISH, "GIF: size: %dx%d, frames: %d, loops: %s, duration: %d", this.mWidth, this.mHeight, this.mImageCount, loopCount, this.mDuration);
        return this.isAnimated() ? "Animated " + suffix : suffix;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mLoopCount);
        dest.writeInt(this.mDuration);
        dest.writeInt(this.mHeight);
        dest.writeInt(this.mWidth);
        dest.writeInt(this.mImageCount);
        dest.writeLong(this.mMetadataBytesCount);
        dest.writeLong(this.mPixelsBytesCount);
    }

    private GifAnimationMetaData(Parcel in) {
        this.mLoopCount = in.readInt();
        this.mDuration = in.readInt();
        this.mHeight = in.readInt();
        this.mWidth = in.readInt();
        this.mImageCount = in.readInt();
        this.mMetadataBytesCount = in.readLong();
        this.mPixelsBytesCount = in.readLong();
    }
}

