/*
 * Decompiled with CFR 0.152.
 */
package ru.fix.stdlib.concurrency.threads;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.concurrent.ForkJoinPool;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import ru.fix.aggregating.profiler.Profiler;
import ru.fix.dynamic.property.api.DynamicProperty;
import ru.fix.stdlib.concurrency.threads.NamedExecutors;
import ru.fix.stdlib.concurrency.threads.ReschedulableScheduler;
import ru.fix.stdlib.concurrency.threads.Schedule;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001Ba\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00126\u0010\n\u001a2\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u000f\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u0011\u0012\u0004\u0012\u00020\u00120\u000b\u00a2\u0006\u0002\u0010\u0013J\b\u0010\u0017\u001a\u00020\u0010H\u0002J\b\u0010\u0018\u001a\u00020\u0012H\u0016R>\u0010\n\u001a2\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u000f\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u0011\u0012\u0004\u0012\u00020\u00120\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0014\u001a\n \u0016*\u0004\u0018\u00010\u00150\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lru/fix/stdlib/concurrency/threads/ThreadPoolGuard;", "Ljava/lang/AutoCloseable;", "profiler", "Lru/fix/aggregating/profiler/Profiler;", "checkRate", "Lru/fix/dynamic/property/api/DynamicProperty;", "Lru/fix/stdlib/concurrency/threads/Schedule;", "predicate", "Lkotlin/Function0;", "", "listener", "Lkotlin/Function2;", "", "Lkotlin/ParameterName;", "name", "queueSize", "", "threadDump", "", "(Lru/fix/aggregating/profiler/Profiler;Lru/fix/dynamic/property/api/DynamicProperty;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function2;)V", "scheduler", "Lru/fix/stdlib/concurrency/threads/ReschedulableScheduler;", "kotlin.jvm.PlatformType", "buildDump", "close", "jfix-stdlib-concurrency"})
public class ThreadPoolGuard
implements AutoCloseable {
    private final ReschedulableScheduler scheduler;
    private final Function0<Boolean> predicate;
    private final Function2<Integer, String, Unit> listener;

    private final String buildDump() {
        ThreadInfo[] threadInfos;
        ThreadMXBean threadMXBean;
        StringBuilder dump = new StringBuilder();
        ThreadMXBean threadMXBean2 = threadMXBean = ManagementFactory.getThreadMXBean();
        Intrinsics.checkExpressionValueIsNotNull((Object)threadMXBean2, (String)"threadMXBean");
        for (ThreadInfo threadInfo : threadInfos = threadMXBean.getThreadInfo(threadMXBean2.getAllThreadIds(), 1000)) {
            StackTraceElement[] stackTraceElements;
            if (threadInfo == null) continue;
            dump.append("\"");
            dump.append(threadInfo.getThreadName());
            dump.append("\" ");
            Thread.State state = threadInfo.getThreadState();
            dump.append((Object)state);
            for (StackTraceElement stackTraceElement : stackTraceElements = threadInfo.getStackTrace()) {
                dump.append("\n    at ");
                dump.append(stackTraceElement);
            }
            dump.append("\n");
        }
        String string = dump.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"dump.toString()");
        return string;
    }

    @Override
    public void close() {
        this.scheduler.shutdown();
    }

    public ThreadPoolGuard(@NotNull Profiler profiler, @NotNull DynamicProperty<Schedule> checkRate, @NotNull Function0<Boolean> predicate, @NotNull Function2<? super Integer, ? super String, Unit> listener) {
        Intrinsics.checkParameterIsNotNull((Object)profiler, (String)"profiler");
        Intrinsics.checkParameterIsNotNull(checkRate, (String)"checkRate");
        Intrinsics.checkParameterIsNotNull(predicate, (String)"predicate");
        Intrinsics.checkParameterIsNotNull(listener, (String)"listener");
        this.predicate = predicate;
        this.listener = listener;
        this.scheduler = NamedExecutors.newScheduler("thread-pool-guard", (DynamicProperty<Integer>)DynamicProperty.of((Object)1), profiler);
        this.scheduler.schedule(checkRate, 0L, new Runnable(){

            @Override
            public final void run() {
                ForkJoinPool forkJoinPool = ForkJoinPool.commonPool();
                Intrinsics.checkExpressionValueIsNotNull((Object)forkJoinPool, (String)"ForkJoinPool.commonPool()");
                int queueSize = forkJoinPool.getQueuedSubmissionCount();
                if (((Boolean)predicate.invoke()).booleanValue()) {
                    listener.invoke((Object)queueSize, (Object)this.buildDump());
                }
            }
        });
    }
}

