/*
 * Decompiled with CFR 0.152.
 */
package ru.noties.tumbleweed.android;

import android.graphics.drawable.Drawable;
import android.os.SystemClock;
import android.support.annotation.NonNull;
import ru.noties.tumbleweed.TweenManagerImpl;
import ru.noties.tumbleweed.android.TimeDelta;

public class DrawableTweenManager
extends TweenManagerImpl {
    private final Drawable drawable;
    private final long frame;
    private final Runnable runnable;
    private final TimeDelta timeDelta = TimeDelta.create();

    @NonNull
    public static DrawableTweenManager create(@NonNull Drawable drawable) {
        return DrawableTweenManager.create(drawable, 0.016666668f);
    }

    @NonNull
    public static DrawableTweenManager create(@NonNull Drawable drawable, float frame) {
        return new DrawableTweenManager(drawable, frame);
    }

    DrawableTweenManager(@NonNull Drawable drawable, float frame) {
        this.drawable = drawable;
        this.frame = (long)(frame * 1000.0f + 0.5f);
        this.runnable = new InvalidateRunnable();
    }

    protected void onStarted() {
        super.onStarted();
        if (this.drawable.getCallback() == null) {
            this.isStarted = false;
        } else {
            this.timeDelta.delta();
            this.drawable.scheduleSelf(this.runnable, SystemClock.uptimeMillis() + 1L);
        }
    }

    protected void onStopped() {
        super.onStopped();
        this.drawable.unscheduleSelf(this.runnable);
    }

    public void update(float delta) {
        super.update(delta);
        if (this.isStarted && !this.isPaused()) {
            this.drawable.invalidateSelf();
        } else if (this.drawable.getCallback() == null) {
            this.onStopped();
        }
    }

    private class InvalidateRunnable
    implements Runnable {
        private InvalidateRunnable() {
        }

        @Override
        public void run() {
            DrawableTweenManager.this.update(DrawableTweenManager.this.timeDelta.delta());
            DrawableTweenManager.this.drawable.scheduleSelf((Runnable)this, SystemClock.uptimeMillis() + DrawableTweenManager.this.frame);
        }
    }
}

