/*
 * Decompiled with CFR 0.152.
 */
package ru.noties.tumbleweed.android;

import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import ru.noties.tumbleweed.TweenManagerImpl;
import ru.noties.tumbleweed.android.TimeDelta;

public class HandlerTweenManager
extends TweenManagerImpl {
    private final long delay;
    private final Handler handler;
    private final Runnable runnable;
    private final TimeDelta timeDelta = TimeDelta.create();

    @NonNull
    public static HandlerTweenManager create() {
        return HandlerTweenManager.create(0.016666668f);
    }

    @NonNull
    public static HandlerTweenManager create(float frame) {
        return HandlerTweenManager.create(frame, new Handler(Looper.getMainLooper()));
    }

    @NonNull
    public static HandlerTweenManager create(float frame, @NonNull Handler handler) {
        return new HandlerTweenManager(frame, handler);
    }

    HandlerTweenManager(float frame, @NonNull Handler handler) {
        this.delay = (long)(frame * 1000.0f + 0.5f);
        this.handler = handler;
        this.runnable = new InvalidateRunnable();
    }

    protected void onStarted() {
        super.onStarted();
        this.timeDelta.delta();
        this.handler.post(this.runnable);
    }

    protected void onStopped() {
        super.onStopped();
        this.handler.removeCallbacks(this.runnable);
    }

    private class InvalidateRunnable
    implements Runnable {
        private InvalidateRunnable() {
        }

        @Override
        public void run() {
            HandlerTweenManager.this.update(HandlerTweenManager.this.timeDelta.delta());
            HandlerTweenManager.this.handler.postDelayed((Runnable)this, HandlerTweenManager.this.delay);
        }
    }
}

