/*
 * Decompiled with CFR 0.152.
 */
package ru.noties.tumbleweed.android;

import android.os.SystemClock;
import android.support.annotation.NonNull;

public abstract class TimeDelta {
    @NonNull
    public static TimeDelta create() {
        return new Impl();
    }

    public abstract float delta();

    private static class Impl
    extends TimeDelta {
        private long lastCallTime;

        private Impl() {
        }

        @Override
        public float delta() {
            long now = SystemClock.uptimeMillis();
            float delta = this.lastCallTime == 0L ? 0.0f : (float)(now - this.lastCallTime) / 1000.0f;
            this.lastCallTime = now;
            return delta;
        }
    }
}

