/*
 * Decompiled with CFR 0.152.
 */
package ru.noties.tumbleweed.android;

import android.support.annotation.IdRes;
import android.support.annotation.NonNull;
import android.support.annotation.UiThread;
import android.view.View;
import android.view.ViewTreeObserver;
import ru.noties.tumbleweed.TweenManagerImpl;
import ru.noties.tumbleweed.android.TimeDelta;

public class ViewTweenManager
extends TweenManagerImpl {
    private final int key;
    private View container;
    private final OnPreDrawListener onPreDrawListener = new OnPreDrawListener();
    private final OnAttachStateChangeListener onAttachStateChangeListener = new OnAttachStateChangeListener();
    private final TimeDelta timeDelta = TimeDelta.create();

    @NonNull
    @UiThread
    public static ViewTweenManager create(@NonNull View container) {
        return new ViewTweenManager(0, container);
    }

    @NonNull
    @UiThread
    public static ViewTweenManager get(@IdRes int key, @NonNull View container) {
        ViewTweenManager manager = (ViewTweenManager)((Object)container.getTag(key));
        if (manager == null) {
            manager = new ViewTweenManager(key, container);
        }
        return manager;
    }

    ViewTweenManager(@IdRes int key, @NonNull View container) {
        this.key = key;
        this.container = container;
        container.addOnAttachStateChangeListener((View.OnAttachStateChangeListener)this.onAttachStateChangeListener);
        if (key != 0) {
            container.setTag(key, (Object)this);
        }
    }

    protected void onStarted() {
        super.onStarted();
        if (!this.isDisposed()) {
            this.timeDelta.delta();
            this.container.getViewTreeObserver().addOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this.onPreDrawListener);
            this.container.invalidate();
        }
    }

    protected void onStopped() {
        super.onStopped();
        if (!this.isDisposed()) {
            this.container.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this.onPreDrawListener);
        }
    }

    public void dispose() {
        if (!this.isDisposed()) {
            ViewTreeObserver observer = this.container.getViewTreeObserver();
            if (observer.isAlive()) {
                observer.removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this.onPreDrawListener);
            }
            if (this.key != 0) {
                this.container.setTag(this.key, null);
            }
            this.container.removeOnAttachStateChangeListener((View.OnAttachStateChangeListener)this.onAttachStateChangeListener);
            this.container = null;
        }
        super.dispose();
    }

    public boolean isDisposed() {
        return super.isDisposed() || this.container == null;
    }

    private class OnAttachStateChangeListener
    implements View.OnAttachStateChangeListener {
        private OnAttachStateChangeListener() {
        }

        public void onViewAttachedToWindow(View v) {
        }

        public void onViewDetachedFromWindow(View v) {
            ViewTweenManager.this.dispose();
        }
    }

    private class OnPreDrawListener
    implements ViewTreeObserver.OnPreDrawListener {
        private OnPreDrawListener() {
        }

        public boolean onPreDraw() {
            if (!ViewTweenManager.this.isDisposed() && ViewTweenManager.this.isStarted) {
                ViewTweenManager.this.update(ViewTweenManager.this.timeDelta.delta());
                ViewTweenManager.this.container.postInvalidateOnAnimation();
            }
            return true;
        }
    }
}

