/*
 * Decompiled with CFR 0.152.
 */
package ru.noties.tumbleweed.android.types;

import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import android.view.View;
import ru.noties.tumbleweed.TweenType;

public abstract class Alpha<T>
implements TweenType<T> {
    @NonNull
    public static final Alpha<View> VIEW = new Alpha<View>(){

        public int getValuesSize() {
            return 1;
        }

        public void getValues(@NonNull View view, @NonNull float[] values) {
            values[0] = view.getAlpha();
        }

        public void setValues(@NonNull View view, @NonNull float[] values) {
            view.setAlpha(values[0]);
        }

        public String toString() {
            return "Alpha.VIEW";
        }
    };
    @RequiresApi(api=19)
    @NonNull
    public static final Alpha<Drawable> DRAWABLE = new Alpha<Drawable>(){

        public int getValuesSize() {
            return 1;
        }

        public void getValues(@NonNull Drawable drawable, @NonNull float[] values) {
            values[0] = (float)drawable.getAlpha() / 255.0f;
        }

        public void setValues(@NonNull Drawable drawable, @NonNull float[] values) {
            drawable.setAlpha((int)(values[0] * 255.0f + 0.5f));
        }

        public String toString() {
            return "Alpha.DRAWABLE";
        }
    };
    @NonNull
    public static final Alpha<Paint> PAINT = new Alpha<Paint>(){

        public int getValuesSize() {
            return 1;
        }

        public void getValues(@NonNull Paint paint, @NonNull float[] values) {
            values[0] = (float)paint.getAlpha() / 255.0f;
        }

        public void setValues(@NonNull Paint paint, @NonNull float[] values) {
            paint.setAlpha((int)(values[0] * 255.0f + 0.5f));
        }

        public String toString() {
            return "Alpha.PAINT";
        }
    };
}

