/*
 * Decompiled with CFR 0.152.
 */
package ru.noties.tumbleweed.android.types;

import android.graphics.Paint;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import android.support.annotation.Size;
import android.view.View;
import android.view.Window;
import android.widget.TextView;
import ru.noties.tumbleweed.TweenType;

public abstract class Argb<T>
implements TweenType<T> {
    @NonNull
    public static final Argb<View> BACKGROUND = new Argb<View>(){

        @Override
        protected int getColor(@NonNull View view) {
            Drawable bg = view.getBackground();
            int color = bg instanceof ColorDrawable ? ((ColorDrawable)bg).getColor() : 0;
            return color;
        }

        @Override
        protected void setColor(@NonNull View view, @ColorInt int color) {
            view.setBackgroundColor(color);
        }

        public String toString() {
            return "Argb.BACKGROUND";
        }
    };
    @NonNull
    public static final Argb<Paint> PAINT = new Argb<Paint>(){

        @Override
        protected int getColor(@NonNull Paint paint) {
            return paint.getColor();
        }

        @Override
        protected void setColor(@NonNull Paint paint, @ColorInt int color) {
            paint.setColor(color);
        }

        public String toString() {
            return "Argb.PAINT";
        }
    };
    @NonNull
    public static final Argb<TextView> TEXT_COLOR = new Argb<TextView>(){

        @Override
        protected int getColor(@NonNull TextView textView) {
            return textView.getCurrentTextColor();
        }

        @Override
        protected void setColor(@NonNull TextView textView, int color) {
            textView.setTextColor(color);
        }

        public String toString() {
            return "Argb.TEXT_COLOR";
        }
    };
    @NonNull
    @RequiresApi(api=21)
    public static final Argb<Window> STATUS_BAR = new Argb<Window>(){

        @Override
        protected int getColor(@NonNull Window window) {
            return window.getStatusBarColor();
        }

        @Override
        protected void setColor(@NonNull Window window, int color) {
            window.setStatusBarColor(color);
        }

        public String toString() {
            return "Argb.STATUS_BAR";
        }
    };
    @NonNull
    public static final Argb<ColorDrawable> COLOR_DRAWABLE = new Argb<ColorDrawable>(){

        @Override
        protected int getColor(@NonNull ColorDrawable colorDrawable) {
            return colorDrawable.getColor();
        }

        @Override
        protected void setColor(@NonNull ColorDrawable colorDrawable, int color) {
            colorDrawable.setColor(color);
        }

        public String toString() {
            return "Argb.COLOR_DRAWABLE";
        }
    };

    @NonNull
    public static float[] toArray(@ColorInt int color) {
        return Argb.toArray(color, new float[4]);
    }

    @NonNull
    public static float[] toArray(@ColorInt int color, @Size(value=4L) @NonNull float[] values) {
        values[0] = (float)(color >> 24 & 0xFF) / 255.0f;
        values[1] = (float)Math.pow((float)(color >> 16 & 0xFF) / 255.0f, 2.2);
        values[2] = (float)Math.pow((float)(color >> 8 & 0xFF) / 255.0f, 2.2);
        values[3] = (float)Math.pow((float)(color & 0xFF) / 255.0f, 2.2);
        return values;
    }

    @ColorInt
    public static int fromArray(@Size(value=4L) @NonNull float[] values) {
        return Math.round(values[0] * 255.0f) << 24 | Math.round((float)Math.pow(values[1], 0.45454545454545453) * 255.0f) << 16 | Math.round((float)Math.pow(values[2], 0.45454545454545453) * 255.0f) << 8 | Math.round((float)Math.pow(values[3], 0.45454545454545453) * 255.0f);
    }

    @ColorInt
    protected abstract int getColor(@NonNull T var1);

    protected abstract void setColor(@NonNull T var1, @ColorInt int var2);

    public int getValuesSize() {
        return 4;
    }

    public void getValues(@NonNull T t, @NonNull float[] values) {
        Argb.toArray(this.getColor(t), values);
    }

    public void setValues(@NonNull T t, @NonNull float[] values) {
        this.setColor(t, Argb.fromArray(values));
    }
}

