/*
 * Decompiled with CFR 0.152.
 */
package ru.noties.tumbleweed.android.types;

import android.graphics.Point;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.RectF;
import android.support.annotation.NonNull;
import android.support.annotation.Size;
import java.util.List;
import ru.noties.tumbleweed.TweenType;

public abstract class Graphics<T>
implements TweenType<T> {
    @NonNull
    public static final Graphics<Rect> RECT = new Graphics<Rect>(){

        public int getValuesSize() {
            return 4;
        }

        public void getValues(@NonNull Rect rect, @NonNull float[] values) {
            1.toArray(rect, values);
        }

        public void setValues(@NonNull Rect rect, @NonNull float[] values) {
            rect.set((int)(values[0] + 0.5f), (int)(values[1] + 0.5f), (int)(values[2] + 0.5f), (int)(values[3] + 0.5f));
        }

        public String toString() {
            return "Graphics.RECT";
        }
    };
    @NonNull
    public static Graphics<RectF> RECT_F = new Graphics<RectF>(){

        public int getValuesSize() {
            return 4;
        }

        public void getValues(@NonNull RectF rectF, @NonNull float[] values) {
            2.toArray(rectF, values);
        }

        public void setValues(@NonNull RectF rectF, @NonNull float[] values) {
            rectF.set(values[0], values[1], values[2], values[3]);
        }

        public String toString() {
            return "Graphics.RECT_F";
        }
    };
    @NonNull
    public static Graphics<Point> POINT = new Graphics<Point>(){

        public int getValuesSize() {
            return 2;
        }

        public void getValues(@NonNull Point point, @NonNull float[] values) {
            3.toArray(point, values);
        }

        public void setValues(@NonNull Point point, @NonNull float[] values) {
            point.set((int)(values[0] + 0.5f), (int)(values[1] + 0.5f));
        }

        public String toString() {
            return "Graphics.POINT";
        }
    };
    @NonNull
    public static Graphics<PointF> POINT_F = new Graphics<PointF>(){

        public int getValuesSize() {
            return 2;
        }

        public void getValues(@NonNull PointF pointF, @NonNull float[] values) {
            4.toArray(pointF, values);
        }

        public void setValues(@NonNull PointF pointF, @NonNull float[] values) {
            pointF.set(values[0], values[1]);
        }

        public String toString() {
            return "Graphics.POINT_F";
        }
    };

    @NonNull
    public static Graphics<List<PointF>> points(@NonNull List<PointF> points) {
        return new Points(points.size() * 2);
    }

    @NonNull
    public static float[] toArray(@NonNull List<PointF> points) {
        return Graphics.toArray(points, new float[points.size() * 2]);
    }

    @NonNull
    public static float[] toArray(@NonNull List<PointF> points, @NonNull float[] values) {
        int length = points.size() * 2 - 1;
        for (int i = 0; i < length; i += 2) {
            PointF pointF = points.get(i / 2);
            values[i] = pointF.x;
            values[i + 1] = pointF.y;
        }
        return values;
    }

    @NonNull
    public static float[] toArray(@NonNull Point point) {
        return Graphics.toArray(point, new float[2]);
    }

    @NonNull
    public static float[] toArray(@NonNull Point point, @Size(value=2L) @NonNull float[] values) {
        values[0] = point.x;
        values[1] = point.y;
        return values;
    }

    @NonNull
    public static float[] toArray(@NonNull PointF pointF) {
        return Graphics.toArray(pointF, new float[2]);
    }

    @NonNull
    public static float[] toArray(@NonNull PointF pointF, @Size(value=2L) @NonNull float[] values) {
        values[0] = pointF.x;
        values[1] = pointF.y;
        return values;
    }

    @NonNull
    public static float[] toArray(@NonNull Rect rect) {
        return Graphics.toArray(rect, new float[4]);
    }

    @NonNull
    public static float[] toArray(@NonNull Rect rect, @Size(value=4L) @NonNull float[] values) {
        values[0] = rect.left;
        values[1] = rect.top;
        values[2] = rect.right;
        values[3] = rect.bottom;
        return values;
    }

    @NonNull
    public static float[] toArray(@NonNull RectF rectF) {
        return Graphics.toArray(rectF, new float[4]);
    }

    @NonNull
    public static float[] toArray(@NonNull RectF rectF, @Size(value=4L) @NonNull float[] values) {
        values[0] = rectF.left;
        values[1] = rectF.top;
        values[2] = rectF.right;
        values[3] = rectF.bottom;
        return values;
    }

    private static class Points
    extends Graphics<List<PointF>> {
        private final int size;

        private Points(int size) {
            this.size = size;
        }

        public int getValuesSize() {
            return this.size;
        }

        public void getValues(@NonNull List<PointF> pointFS, @NonNull float[] values) {
            Points.toArray(pointFS, values);
        }

        public void setValues(@NonNull List<PointF> pointFS, @NonNull float[] values) {
            for (int i = 0; i < this.size - 1; i += 2) {
                pointFS.get(i / 2).set(values[i], values[i + 1]);
            }
        }

        public String toString() {
            return "Graphics.points(" + this.size + ")";
        }
    }
}

