/*
 * Decompiled with CFR 0.152.
 */
package ru.noties.tumbleweed.android.utils;

import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.SparseBooleanArray;
import android.view.View;
import android.view.ViewGroup;

public abstract class ClipChildren {
    @Nullable
    public static State disable(@NonNull View view) {
        StateImpl state;
        if (Build.VERSION.SDK_INT >= 18) {
            SparseBooleanArray array = new SparseBooleanArray();
            ViewGroup group = ClipChildren.initial(view);
            while (group != null) {
                array.put(group.hashCode(), group.getClipChildren());
                group.setClipChildren(false);
                group = ClipChildren.next(group);
            }
            state = new StateImpl(array);
        } else {
            state = null;
        }
        return state;
    }

    @Nullable
    private static ViewGroup initial(@NonNull View view) {
        return view instanceof ViewGroup ? (ViewGroup)view : (view.getParent() instanceof ViewGroup ? (ViewGroup)view.getParent() : null);
    }

    @Nullable
    private static ViewGroup next(@NonNull ViewGroup group) {
        return group.getParent() instanceof ViewGroup ? (ViewGroup)group.getParent() : null;
    }

    private static class StateImpl
    implements State {
        private final SparseBooleanArray sparseBooleanArray;

        private StateImpl(@NonNull SparseBooleanArray sparseBooleanArray) {
            this.sparseBooleanArray = sparseBooleanArray;
        }

        @Override
        public void restore(@NonNull View view) {
            if (this.sparseBooleanArray.size() == 0) {
                return;
            }
            ViewGroup group = ClipChildren.initial(view);
            while (group != null) {
                int hash = group.hashCode();
                if (this.sparseBooleanArray.indexOfKey(hash) > -1) {
                    group.setClipChildren(this.sparseBooleanArray.get(hash));
                }
                group = ClipChildren.next(group);
            }
        }
    }

    public static interface State {
        public void restore(@NonNull View var1);
    }
}

