/*
 * Decompiled with CFR 0.152.
 */
package ru.noties.tumbleweed.android.utils;

import android.graphics.Point;
import android.support.annotation.NonNull;
import android.view.View;
import android.view.ViewTreeObserver;

public abstract class ViewUtils {
    public static <V extends View> void whenReady(final @NonNull V v, final @NonNull Action<V> action) {
        if (v.getWidth() == 0 || v.getHeight() == 0) {
            v.getViewTreeObserver().addOnPreDrawListener(new ViewTreeObserver.OnPreDrawListener(){

                public boolean onPreDraw() {
                    v.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
                    action.apply(v);
                    return true;
                }
            });
        } else {
            action.apply(v);
        }
    }

    @NonNull
    public static Point relativeTo(@NonNull View parent, @NonNull View who) {
        return ViewUtils.relativeTo(parent, who, new Point());
    }

    @NonNull
    public static Point relativeTo(@NonNull View parent, @NonNull View who, @NonNull Point point) {
        point.x += who.getLeft();
        point.y += who.getTop();
        if (who != parent && who.getParent() instanceof View) {
            ViewUtils.relativeTo(parent, (View)who.getParent(), point);
        }
        return point;
    }

    private ViewUtils() {
    }

    public static interface Action<V extends View> {
        public void apply(@NonNull V var1);
    }
}

