/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.java.generics.resolver.error;

import java.lang.reflect.Constructor;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;
import ru.vyarus.java.generics.resolver.context.GenericDeclarationScope;
import ru.vyarus.java.generics.resolver.context.GenericsInfo;
import ru.vyarus.java.generics.resolver.error.GenericSourceException;
import ru.vyarus.java.generics.resolver.util.GenericsUtils;
import ru.vyarus.java.generics.resolver.util.TypeToStringUtils;
import ru.vyarus.java.generics.resolver.util.map.PrintableGenericsMap;

public class WrongGenericsContextException
extends GenericSourceException {
    private static final PrintableGenericsMap PRINTABLE_GENERICS = new PrintableGenericsMap();
    private final Type type;
    private final TypeVariable variable;
    private final Class<?> context;

    public WrongGenericsContextException(Type type, TypeVariable variable, Class<?> context, GenericsInfo info) {
        super(String.format("Type %s contains generic '%s'%s and can't be resolved in context of current class %s. %s", TypeToStringUtils.toStringType(type, PRINTABLE_GENERICS), variable.getName(), WrongGenericsContextException.formatSource(variable.getGenericDeclaration()), context.getSimpleName(), WrongGenericsContextException.formatCompatibility(variable, info)));
        this.type = type;
        this.variable = variable;
        this.context = context;
    }

    public Type getType() {
        return this.type;
    }

    @Override
    public String getGenericName() {
        return this.variable.getName();
    }

    @Override
    public GenericDeclaration getGenericSource() {
        return this.variable.getGenericDeclaration();
    }

    @Override
    public Class<?> getContextType() {
        return this.context;
    }

    private static String formatCompatibility(TypeVariable variable, GenericsInfo info) {
        String res;
        Class<?> genericTarget = GenericsUtils.getDeclarationClass(variable);
        if (genericTarget == null) {
            return "";
        }
        Class<?> requiredContext = info.findContextByDeclarationType(genericTarget);
        if (requiredContext != null) {
            String nav;
            switch (GenericDeclarationScope.from(variable.getGenericDeclaration())) {
                case METHOD: {
                    nav = String.format("context.method(%s)", WrongGenericsContextException.formatMethodGet((Method)variable.getGenericDeclaration()));
                    break;
                }
                case CONSTRUCTOR: {
                    nav = String.format("context.constructor(%s)", WrongGenericsContextException.formatConstructorGet((Constructor)variable.getGenericDeclaration()));
                    break;
                }
                default: {
                    nav = String.format("context.type(%s.class)", requiredContext.getSimpleName());
                }
            }
            res = "Switch context to handle generic properly: " + nav;
        } else {
            res = Arrays.asList(info.getIgnoredTypes()).contains(genericTarget) ? String.format("Generic declaration type %s is ignored in current context hierarchy:%n%s", genericTarget.getSimpleName(), info.toString()) : String.format("Generic does not belong to any type in current context hierarchy:%n%s", info.toString());
        }
        return res;
    }

    private static String formatMethodGet(Method method) {
        StringBuilder res = new StringBuilder(60);
        res.append(method.getDeclaringClass().getSimpleName()).append(".class.getDeclaredMethod(\"").append(method.getName()).append('\"');
        WrongGenericsContextException.formatParametersTail(res, false, method.getParameterTypes());
        return res.toString();
    }

    private static String formatConstructorGet(Constructor ctor) {
        StringBuilder res = new StringBuilder(60);
        res.append(ctor.getDeclaringClass().getSimpleName()).append(".class.getConstructor(");
        WrongGenericsContextException.formatParametersTail(res, true, ctor.getParameterTypes());
        return res.toString();
    }

    private static void formatParametersTail(StringBuilder res, boolean first, Class<?> ... params) {
        boolean isFirst = first;
        for (Class<?> par : params) {
            res.append(isFirst ? "" : ", ").append(par.getSimpleName()).append(".class");
            isFirst = false;
        }
        res.append(')');
    }
}

