/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the registered connector.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConnectorDetail implements SdkPojo, Serializable, ToCopyableBuilder<ConnectorDetail.Builder, ConnectorDetail> {
    private static final SdkField<String> CONNECTOR_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("connectorDescription").getter(getter(ConnectorDetail::connectorDescription))
            .setter(setter(Builder::connectorDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorDescription").build())
            .build();

    private static final SdkField<String> CONNECTOR_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("connectorName").getter(getter(ConnectorDetail::connectorName)).setter(setter(Builder::connectorName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorName").build()).build();

    private static final SdkField<String> CONNECTOR_OWNER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("connectorOwner").getter(getter(ConnectorDetail::connectorOwner)).setter(setter(Builder::connectorOwner))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorOwner").build()).build();

    private static final SdkField<String> CONNECTOR_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("connectorVersion").getter(getter(ConnectorDetail::connectorVersion))
            .setter(setter(Builder::connectorVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorVersion").build()).build();

    private static final SdkField<String> APPLICATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("applicationType").getter(getter(ConnectorDetail::applicationType))
            .setter(setter(Builder::applicationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationType").build()).build();

    private static final SdkField<String> CONNECTOR_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("connectorType").getter(getter(ConnectorDetail::connectorTypeAsString))
            .setter(setter(Builder::connectorType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorType").build()).build();

    private static final SdkField<String> CONNECTOR_LABEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("connectorLabel").getter(getter(ConnectorDetail::connectorLabel)).setter(setter(Builder::connectorLabel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorLabel").build()).build();

    private static final SdkField<Instant> REGISTERED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("registeredAt").getter(getter(ConnectorDetail::registeredAt)).setter(setter(Builder::registeredAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registeredAt").build()).build();

    private static final SdkField<String> REGISTERED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("registeredBy").getter(getter(ConnectorDetail::registeredBy)).setter(setter(Builder::registeredBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registeredBy").build()).build();

    private static final SdkField<String> CONNECTOR_PROVISIONING_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("connectorProvisioningType").getter(getter(ConnectorDetail::connectorProvisioningTypeAsString))
            .setter(setter(Builder::connectorProvisioningType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorProvisioningType").build())
            .build();

    private static final SdkField<List<String>> CONNECTOR_MODES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("connectorModes")
            .getter(getter(ConnectorDetail::connectorModes))
            .setter(setter(Builder::connectorModes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorModes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SUPPORTED_DATA_TRANSFER_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("supportedDataTransferTypes")
            .getter(getter(ConnectorDetail::supportedDataTransferTypesAsStrings))
            .setter(setter(Builder::supportedDataTransferTypesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("supportedDataTransferTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTOR_DESCRIPTION_FIELD,
            CONNECTOR_NAME_FIELD, CONNECTOR_OWNER_FIELD, CONNECTOR_VERSION_FIELD, APPLICATION_TYPE_FIELD, CONNECTOR_TYPE_FIELD,
            CONNECTOR_LABEL_FIELD, REGISTERED_AT_FIELD, REGISTERED_BY_FIELD, CONNECTOR_PROVISIONING_TYPE_FIELD,
            CONNECTOR_MODES_FIELD, SUPPORTED_DATA_TRANSFER_TYPES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String connectorDescription;

    private final String connectorName;

    private final String connectorOwner;

    private final String connectorVersion;

    private final String applicationType;

    private final String connectorType;

    private final String connectorLabel;

    private final Instant registeredAt;

    private final String registeredBy;

    private final String connectorProvisioningType;

    private final List<String> connectorModes;

    private final List<String> supportedDataTransferTypes;

    private ConnectorDetail(BuilderImpl builder) {
        this.connectorDescription = builder.connectorDescription;
        this.connectorName = builder.connectorName;
        this.connectorOwner = builder.connectorOwner;
        this.connectorVersion = builder.connectorVersion;
        this.applicationType = builder.applicationType;
        this.connectorType = builder.connectorType;
        this.connectorLabel = builder.connectorLabel;
        this.registeredAt = builder.registeredAt;
        this.registeredBy = builder.registeredBy;
        this.connectorProvisioningType = builder.connectorProvisioningType;
        this.connectorModes = builder.connectorModes;
        this.supportedDataTransferTypes = builder.supportedDataTransferTypes;
    }

    /**
     * <p>
     * A description about the registered connector.
     * </p>
     * 
     * @return A description about the registered connector.
     */
    public final String connectorDescription() {
        return connectorDescription;
    }

    /**
     * <p>
     * The name of the connector.
     * </p>
     * 
     * @return The name of the connector.
     */
    public final String connectorName() {
        return connectorName;
    }

    /**
     * <p>
     * The owner of the connector.
     * </p>
     * 
     * @return The owner of the connector.
     */
    public final String connectorOwner() {
        return connectorOwner;
    }

    /**
     * <p>
     * The connector version.
     * </p>
     * 
     * @return The connector version.
     */
    public final String connectorVersion() {
        return connectorVersion;
    }

    /**
     * <p>
     * The application type of the connector.
     * </p>
     * 
     * @return The application type of the connector.
     */
    public final String applicationType() {
        return applicationType;
    }

    /**
     * <p>
     * The connector type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #connectorType}
     * will return {@link ConnectorType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #connectorTypeAsString}.
     * </p>
     * 
     * @return The connector type.
     * @see ConnectorType
     */
    public final ConnectorType connectorType() {
        return ConnectorType.fromValue(connectorType);
    }

    /**
     * <p>
     * The connector type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #connectorType}
     * will return {@link ConnectorType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #connectorTypeAsString}.
     * </p>
     * 
     * @return The connector type.
     * @see ConnectorType
     */
    public final String connectorTypeAsString() {
        return connectorType;
    }

    /**
     * <p>
     * A label used for the connector.
     * </p>
     * 
     * @return A label used for the connector.
     */
    public final String connectorLabel() {
        return connectorLabel;
    }

    /**
     * <p>
     * The time at which the connector was registered.
     * </p>
     * 
     * @return The time at which the connector was registered.
     */
    public final Instant registeredAt() {
        return registeredAt;
    }

    /**
     * <p>
     * The user who registered the connector.
     * </p>
     * 
     * @return The user who registered the connector.
     */
    public final String registeredBy() {
        return registeredBy;
    }

    /**
     * <p>
     * The provisioning type that the connector uses.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #connectorProvisioningType} will return {@link ConnectorProvisioningType#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #connectorProvisioningTypeAsString}.
     * </p>
     * 
     * @return The provisioning type that the connector uses.
     * @see ConnectorProvisioningType
     */
    public final ConnectorProvisioningType connectorProvisioningType() {
        return ConnectorProvisioningType.fromValue(connectorProvisioningType);
    }

    /**
     * <p>
     * The provisioning type that the connector uses.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #connectorProvisioningType} will return {@link ConnectorProvisioningType#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #connectorProvisioningTypeAsString}.
     * </p>
     * 
     * @return The provisioning type that the connector uses.
     * @see ConnectorProvisioningType
     */
    public final String connectorProvisioningTypeAsString() {
        return connectorProvisioningType;
    }

    /**
     * For responses, this returns true if the service returned a value for the ConnectorModes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasConnectorModes() {
        return connectorModes != null && !(connectorModes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The connection mode that the connector supports.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasConnectorModes} method.
     * </p>
     * 
     * @return The connection mode that the connector supports.
     */
    public final List<String> connectorModes() {
        return connectorModes;
    }

    /**
     * <p>
     * The data transfer types that the connector supports.
     * </p>
     * <dl>
     * <dt>RECORD</dt>
     * <dd>
     * <p>
     * Structured records.
     * </p>
     * </dd>
     * <dt>FILE</dt>
     * <dd>
     * <p>
     * Files or binary data.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSupportedDataTransferTypes} method.
     * </p>
     * 
     * @return The data transfer types that the connector supports.</p>
     *         <dl>
     *         <dt>RECORD</dt>
     *         <dd>
     *         <p>
     *         Structured records.
     *         </p>
     *         </dd>
     *         <dt>FILE</dt>
     *         <dd>
     *         <p>
     *         Files or binary data.
     *         </p>
     *         </dd>
     */
    public final List<SupportedDataTransferType> supportedDataTransferTypes() {
        return SupportedDataTransferTypeListCopier.copyStringToEnum(supportedDataTransferTypes);
    }

    /**
     * For responses, this returns true if the service returned a value for the SupportedDataTransferTypes property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasSupportedDataTransferTypes() {
        return supportedDataTransferTypes != null && !(supportedDataTransferTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The data transfer types that the connector supports.
     * </p>
     * <dl>
     * <dt>RECORD</dt>
     * <dd>
     * <p>
     * Structured records.
     * </p>
     * </dd>
     * <dt>FILE</dt>
     * <dd>
     * <p>
     * Files or binary data.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSupportedDataTransferTypes} method.
     * </p>
     * 
     * @return The data transfer types that the connector supports.</p>
     *         <dl>
     *         <dt>RECORD</dt>
     *         <dd>
     *         <p>
     *         Structured records.
     *         </p>
     *         </dd>
     *         <dt>FILE</dt>
     *         <dd>
     *         <p>
     *         Files or binary data.
     *         </p>
     *         </dd>
     */
    public final List<String> supportedDataTransferTypesAsStrings() {
        return supportedDataTransferTypes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(connectorDescription());
        hashCode = 31 * hashCode + Objects.hashCode(connectorName());
        hashCode = 31 * hashCode + Objects.hashCode(connectorOwner());
        hashCode = 31 * hashCode + Objects.hashCode(connectorVersion());
        hashCode = 31 * hashCode + Objects.hashCode(applicationType());
        hashCode = 31 * hashCode + Objects.hashCode(connectorTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(connectorLabel());
        hashCode = 31 * hashCode + Objects.hashCode(registeredAt());
        hashCode = 31 * hashCode + Objects.hashCode(registeredBy());
        hashCode = 31 * hashCode + Objects.hashCode(connectorProvisioningTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasConnectorModes() ? connectorModes() : null);
        hashCode = 31 * hashCode
                + Objects.hashCode(hasSupportedDataTransferTypes() ? supportedDataTransferTypesAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectorDetail)) {
            return false;
        }
        ConnectorDetail other = (ConnectorDetail) obj;
        return Objects.equals(connectorDescription(), other.connectorDescription())
                && Objects.equals(connectorName(), other.connectorName())
                && Objects.equals(connectorOwner(), other.connectorOwner())
                && Objects.equals(connectorVersion(), other.connectorVersion())
                && Objects.equals(applicationType(), other.applicationType())
                && Objects.equals(connectorTypeAsString(), other.connectorTypeAsString())
                && Objects.equals(connectorLabel(), other.connectorLabel())
                && Objects.equals(registeredAt(), other.registeredAt()) && Objects.equals(registeredBy(), other.registeredBy())
                && Objects.equals(connectorProvisioningTypeAsString(), other.connectorProvisioningTypeAsString())
                && hasConnectorModes() == other.hasConnectorModes() && Objects.equals(connectorModes(), other.connectorModes())
                && hasSupportedDataTransferTypes() == other.hasSupportedDataTransferTypes()
                && Objects.equals(supportedDataTransferTypesAsStrings(), other.supportedDataTransferTypesAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("ConnectorDetail")
                .add("ConnectorDescription", connectorDescription())
                .add("ConnectorName", connectorName())
                .add("ConnectorOwner", connectorOwner())
                .add("ConnectorVersion", connectorVersion())
                .add("ApplicationType", applicationType())
                .add("ConnectorType", connectorTypeAsString())
                .add("ConnectorLabel", connectorLabel())
                .add("RegisteredAt", registeredAt())
                .add("RegisteredBy", registeredBy())
                .add("ConnectorProvisioningType", connectorProvisioningTypeAsString())
                .add("ConnectorModes", hasConnectorModes() ? connectorModes() : null)
                .add("SupportedDataTransferTypes", hasSupportedDataTransferTypes() ? supportedDataTransferTypesAsStrings() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "connectorDescription":
            return Optional.ofNullable(clazz.cast(connectorDescription()));
        case "connectorName":
            return Optional.ofNullable(clazz.cast(connectorName()));
        case "connectorOwner":
            return Optional.ofNullable(clazz.cast(connectorOwner()));
        case "connectorVersion":
            return Optional.ofNullable(clazz.cast(connectorVersion()));
        case "applicationType":
            return Optional.ofNullable(clazz.cast(applicationType()));
        case "connectorType":
            return Optional.ofNullable(clazz.cast(connectorTypeAsString()));
        case "connectorLabel":
            return Optional.ofNullable(clazz.cast(connectorLabel()));
        case "registeredAt":
            return Optional.ofNullable(clazz.cast(registeredAt()));
        case "registeredBy":
            return Optional.ofNullable(clazz.cast(registeredBy()));
        case "connectorProvisioningType":
            return Optional.ofNullable(clazz.cast(connectorProvisioningTypeAsString()));
        case "connectorModes":
            return Optional.ofNullable(clazz.cast(connectorModes()));
        case "supportedDataTransferTypes":
            return Optional.ofNullable(clazz.cast(supportedDataTransferTypesAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConnectorDetail, T> g) {
        return obj -> g.apply((ConnectorDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConnectorDetail> {
        /**
         * <p>
         * A description about the registered connector.
         * </p>
         * 
         * @param connectorDescription
         *        A description about the registered connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectorDescription(String connectorDescription);

        /**
         * <p>
         * The name of the connector.
         * </p>
         * 
         * @param connectorName
         *        The name of the connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectorName(String connectorName);

        /**
         * <p>
         * The owner of the connector.
         * </p>
         * 
         * @param connectorOwner
         *        The owner of the connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectorOwner(String connectorOwner);

        /**
         * <p>
         * The connector version.
         * </p>
         * 
         * @param connectorVersion
         *        The connector version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectorVersion(String connectorVersion);

        /**
         * <p>
         * The application type of the connector.
         * </p>
         * 
         * @param applicationType
         *        The application type of the connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationType(String applicationType);

        /**
         * <p>
         * The connector type.
         * </p>
         * 
         * @param connectorType
         *        The connector type.
         * @see ConnectorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectorType
         */
        Builder connectorType(String connectorType);

        /**
         * <p>
         * The connector type.
         * </p>
         * 
         * @param connectorType
         *        The connector type.
         * @see ConnectorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectorType
         */
        Builder connectorType(ConnectorType connectorType);

        /**
         * <p>
         * A label used for the connector.
         * </p>
         * 
         * @param connectorLabel
         *        A label used for the connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectorLabel(String connectorLabel);

        /**
         * <p>
         * The time at which the connector was registered.
         * </p>
         * 
         * @param registeredAt
         *        The time at which the connector was registered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registeredAt(Instant registeredAt);

        /**
         * <p>
         * The user who registered the connector.
         * </p>
         * 
         * @param registeredBy
         *        The user who registered the connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registeredBy(String registeredBy);

        /**
         * <p>
         * The provisioning type that the connector uses.
         * </p>
         * 
         * @param connectorProvisioningType
         *        The provisioning type that the connector uses.
         * @see ConnectorProvisioningType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectorProvisioningType
         */
        Builder connectorProvisioningType(String connectorProvisioningType);

        /**
         * <p>
         * The provisioning type that the connector uses.
         * </p>
         * 
         * @param connectorProvisioningType
         *        The provisioning type that the connector uses.
         * @see ConnectorProvisioningType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectorProvisioningType
         */
        Builder connectorProvisioningType(ConnectorProvisioningType connectorProvisioningType);

        /**
         * <p>
         * The connection mode that the connector supports.
         * </p>
         * 
         * @param connectorModes
         *        The connection mode that the connector supports.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectorModes(Collection<String> connectorModes);

        /**
         * <p>
         * The connection mode that the connector supports.
         * </p>
         * 
         * @param connectorModes
         *        The connection mode that the connector supports.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectorModes(String... connectorModes);

        /**
         * <p>
         * The data transfer types that the connector supports.
         * </p>
         * <dl>
         * <dt>RECORD</dt>
         * <dd>
         * <p>
         * Structured records.
         * </p>
         * </dd>
         * <dt>FILE</dt>
         * <dd>
         * <p>
         * Files or binary data.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param supportedDataTransferTypes
         *        The data transfer types that the connector supports.</p>
         *        <dl>
         *        <dt>RECORD</dt>
         *        <dd>
         *        <p>
         *        Structured records.
         *        </p>
         *        </dd>
         *        <dt>FILE</dt>
         *        <dd>
         *        <p>
         *        Files or binary data.
         *        </p>
         *        </dd>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedDataTransferTypesWithStrings(Collection<String> supportedDataTransferTypes);

        /**
         * <p>
         * The data transfer types that the connector supports.
         * </p>
         * <dl>
         * <dt>RECORD</dt>
         * <dd>
         * <p>
         * Structured records.
         * </p>
         * </dd>
         * <dt>FILE</dt>
         * <dd>
         * <p>
         * Files or binary data.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param supportedDataTransferTypes
         *        The data transfer types that the connector supports.</p>
         *        <dl>
         *        <dt>RECORD</dt>
         *        <dd>
         *        <p>
         *        Structured records.
         *        </p>
         *        </dd>
         *        <dt>FILE</dt>
         *        <dd>
         *        <p>
         *        Files or binary data.
         *        </p>
         *        </dd>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedDataTransferTypesWithStrings(String... supportedDataTransferTypes);

        /**
         * <p>
         * The data transfer types that the connector supports.
         * </p>
         * <dl>
         * <dt>RECORD</dt>
         * <dd>
         * <p>
         * Structured records.
         * </p>
         * </dd>
         * <dt>FILE</dt>
         * <dd>
         * <p>
         * Files or binary data.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param supportedDataTransferTypes
         *        The data transfer types that the connector supports.</p>
         *        <dl>
         *        <dt>RECORD</dt>
         *        <dd>
         *        <p>
         *        Structured records.
         *        </p>
         *        </dd>
         *        <dt>FILE</dt>
         *        <dd>
         *        <p>
         *        Files or binary data.
         *        </p>
         *        </dd>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedDataTransferTypes(Collection<SupportedDataTransferType> supportedDataTransferTypes);

        /**
         * <p>
         * The data transfer types that the connector supports.
         * </p>
         * <dl>
         * <dt>RECORD</dt>
         * <dd>
         * <p>
         * Structured records.
         * </p>
         * </dd>
         * <dt>FILE</dt>
         * <dd>
         * <p>
         * Files or binary data.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param supportedDataTransferTypes
         *        The data transfer types that the connector supports.</p>
         *        <dl>
         *        <dt>RECORD</dt>
         *        <dd>
         *        <p>
         *        Structured records.
         *        </p>
         *        </dd>
         *        <dt>FILE</dt>
         *        <dd>
         *        <p>
         *        Files or binary data.
         *        </p>
         *        </dd>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedDataTransferTypes(SupportedDataTransferType... supportedDataTransferTypes);
    }

    static final class BuilderImpl implements Builder {
        private String connectorDescription;

        private String connectorName;

        private String connectorOwner;

        private String connectorVersion;

        private String applicationType;

        private String connectorType;

        private String connectorLabel;

        private Instant registeredAt;

        private String registeredBy;

        private String connectorProvisioningType;

        private List<String> connectorModes = DefaultSdkAutoConstructList.getInstance();

        private List<String> supportedDataTransferTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectorDetail model) {
            connectorDescription(model.connectorDescription);
            connectorName(model.connectorName);
            connectorOwner(model.connectorOwner);
            connectorVersion(model.connectorVersion);
            applicationType(model.applicationType);
            connectorType(model.connectorType);
            connectorLabel(model.connectorLabel);
            registeredAt(model.registeredAt);
            registeredBy(model.registeredBy);
            connectorProvisioningType(model.connectorProvisioningType);
            connectorModes(model.connectorModes);
            supportedDataTransferTypesWithStrings(model.supportedDataTransferTypes);
        }

        public final String getConnectorDescription() {
            return connectorDescription;
        }

        public final void setConnectorDescription(String connectorDescription) {
            this.connectorDescription = connectorDescription;
        }

        @Override
        public final Builder connectorDescription(String connectorDescription) {
            this.connectorDescription = connectorDescription;
            return this;
        }

        public final String getConnectorName() {
            return connectorName;
        }

        public final void setConnectorName(String connectorName) {
            this.connectorName = connectorName;
        }

        @Override
        public final Builder connectorName(String connectorName) {
            this.connectorName = connectorName;
            return this;
        }

        public final String getConnectorOwner() {
            return connectorOwner;
        }

        public final void setConnectorOwner(String connectorOwner) {
            this.connectorOwner = connectorOwner;
        }

        @Override
        public final Builder connectorOwner(String connectorOwner) {
            this.connectorOwner = connectorOwner;
            return this;
        }

        public final String getConnectorVersion() {
            return connectorVersion;
        }

        public final void setConnectorVersion(String connectorVersion) {
            this.connectorVersion = connectorVersion;
        }

        @Override
        public final Builder connectorVersion(String connectorVersion) {
            this.connectorVersion = connectorVersion;
            return this;
        }

        public final String getApplicationType() {
            return applicationType;
        }

        public final void setApplicationType(String applicationType) {
            this.applicationType = applicationType;
        }

        @Override
        public final Builder applicationType(String applicationType) {
            this.applicationType = applicationType;
            return this;
        }

        public final String getConnectorType() {
            return connectorType;
        }

        public final void setConnectorType(String connectorType) {
            this.connectorType = connectorType;
        }

        @Override
        public final Builder connectorType(String connectorType) {
            this.connectorType = connectorType;
            return this;
        }

        @Override
        public final Builder connectorType(ConnectorType connectorType) {
            this.connectorType(connectorType == null ? null : connectorType.toString());
            return this;
        }

        public final String getConnectorLabel() {
            return connectorLabel;
        }

        public final void setConnectorLabel(String connectorLabel) {
            this.connectorLabel = connectorLabel;
        }

        @Override
        public final Builder connectorLabel(String connectorLabel) {
            this.connectorLabel = connectorLabel;
            return this;
        }

        public final Instant getRegisteredAt() {
            return registeredAt;
        }

        public final void setRegisteredAt(Instant registeredAt) {
            this.registeredAt = registeredAt;
        }

        @Override
        public final Builder registeredAt(Instant registeredAt) {
            this.registeredAt = registeredAt;
            return this;
        }

        public final String getRegisteredBy() {
            return registeredBy;
        }

        public final void setRegisteredBy(String registeredBy) {
            this.registeredBy = registeredBy;
        }

        @Override
        public final Builder registeredBy(String registeredBy) {
            this.registeredBy = registeredBy;
            return this;
        }

        public final String getConnectorProvisioningType() {
            return connectorProvisioningType;
        }

        public final void setConnectorProvisioningType(String connectorProvisioningType) {
            this.connectorProvisioningType = connectorProvisioningType;
        }

        @Override
        public final Builder connectorProvisioningType(String connectorProvisioningType) {
            this.connectorProvisioningType = connectorProvisioningType;
            return this;
        }

        @Override
        public final Builder connectorProvisioningType(ConnectorProvisioningType connectorProvisioningType) {
            this.connectorProvisioningType(connectorProvisioningType == null ? null : connectorProvisioningType.toString());
            return this;
        }

        public final Collection<String> getConnectorModes() {
            if (connectorModes instanceof SdkAutoConstructList) {
                return null;
            }
            return connectorModes;
        }

        public final void setConnectorModes(Collection<String> connectorModes) {
            this.connectorModes = ConnectorModeListCopier.copy(connectorModes);
        }

        @Override
        public final Builder connectorModes(Collection<String> connectorModes) {
            this.connectorModes = ConnectorModeListCopier.copy(connectorModes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connectorModes(String... connectorModes) {
            connectorModes(Arrays.asList(connectorModes));
            return this;
        }

        public final Collection<String> getSupportedDataTransferTypes() {
            if (supportedDataTransferTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return supportedDataTransferTypes;
        }

        public final void setSupportedDataTransferTypes(Collection<String> supportedDataTransferTypes) {
            this.supportedDataTransferTypes = SupportedDataTransferTypeListCopier.copy(supportedDataTransferTypes);
        }

        @Override
        public final Builder supportedDataTransferTypesWithStrings(Collection<String> supportedDataTransferTypes) {
            this.supportedDataTransferTypes = SupportedDataTransferTypeListCopier.copy(supportedDataTransferTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedDataTransferTypesWithStrings(String... supportedDataTransferTypes) {
            supportedDataTransferTypesWithStrings(Arrays.asList(supportedDataTransferTypes));
            return this;
        }

        @Override
        public final Builder supportedDataTransferTypes(Collection<SupportedDataTransferType> supportedDataTransferTypes) {
            this.supportedDataTransferTypes = SupportedDataTransferTypeListCopier.copyEnumToString(supportedDataTransferTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedDataTransferTypes(SupportedDataTransferType... supportedDataTransferTypes) {
            supportedDataTransferTypes(Arrays.asList(supportedDataTransferTypes));
            return this;
        }

        @Override
        public ConnectorDetail build() {
            return new ConnectorDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
