/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The connector-specific profile properties required when using Salesforce Pardot.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PardotConnectorProfileProperties implements SdkPojo, Serializable,
        ToCopyableBuilder<PardotConnectorProfileProperties.Builder, PardotConnectorProfileProperties> {
    private static final SdkField<String> INSTANCE_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("instanceUrl").getter(getter(PardotConnectorProfileProperties::instanceUrl))
            .setter(setter(Builder::instanceUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceUrl").build()).build();

    private static final SdkField<Boolean> IS_SANDBOX_ENVIRONMENT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isSandboxEnvironment").getter(getter(PardotConnectorProfileProperties::isSandboxEnvironment))
            .setter(setter(Builder::isSandboxEnvironment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isSandboxEnvironment").build())
            .build();

    private static final SdkField<String> BUSINESS_UNIT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("businessUnitId").getter(getter(PardotConnectorProfileProperties::businessUnitId))
            .setter(setter(Builder::businessUnitId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("businessUnitId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_URL_FIELD,
            IS_SANDBOX_ENVIRONMENT_FIELD, BUSINESS_UNIT_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String instanceUrl;

    private final Boolean isSandboxEnvironment;

    private final String businessUnitId;

    private PardotConnectorProfileProperties(BuilderImpl builder) {
        this.instanceUrl = builder.instanceUrl;
        this.isSandboxEnvironment = builder.isSandboxEnvironment;
        this.businessUnitId = builder.businessUnitId;
    }

    /**
     * <p>
     * The location of the Salesforce Pardot resource.
     * </p>
     * 
     * @return The location of the Salesforce Pardot resource.
     */
    public final String instanceUrl() {
        return instanceUrl;
    }

    /**
     * <p>
     * Indicates whether the connector profile applies to a sandbox or production environment.
     * </p>
     * 
     * @return Indicates whether the connector profile applies to a sandbox or production environment.
     */
    public final Boolean isSandboxEnvironment() {
        return isSandboxEnvironment;
    }

    /**
     * <p>
     * The business unit id of Salesforce Pardot instance.
     * </p>
     * 
     * @return The business unit id of Salesforce Pardot instance.
     */
    public final String businessUnitId() {
        return businessUnitId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instanceUrl());
        hashCode = 31 * hashCode + Objects.hashCode(isSandboxEnvironment());
        hashCode = 31 * hashCode + Objects.hashCode(businessUnitId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PardotConnectorProfileProperties)) {
            return false;
        }
        PardotConnectorProfileProperties other = (PardotConnectorProfileProperties) obj;
        return Objects.equals(instanceUrl(), other.instanceUrl())
                && Objects.equals(isSandboxEnvironment(), other.isSandboxEnvironment())
                && Objects.equals(businessUnitId(), other.businessUnitId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PardotConnectorProfileProperties").add("InstanceUrl", instanceUrl())
                .add("IsSandboxEnvironment", isSandboxEnvironment()).add("BusinessUnitId", businessUnitId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "instanceUrl":
            return Optional.ofNullable(clazz.cast(instanceUrl()));
        case "isSandboxEnvironment":
            return Optional.ofNullable(clazz.cast(isSandboxEnvironment()));
        case "businessUnitId":
            return Optional.ofNullable(clazz.cast(businessUnitId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PardotConnectorProfileProperties, T> g) {
        return obj -> g.apply((PardotConnectorProfileProperties) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PardotConnectorProfileProperties> {
        /**
         * <p>
         * The location of the Salesforce Pardot resource.
         * </p>
         * 
         * @param instanceUrl
         *        The location of the Salesforce Pardot resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceUrl(String instanceUrl);

        /**
         * <p>
         * Indicates whether the connector profile applies to a sandbox or production environment.
         * </p>
         * 
         * @param isSandboxEnvironment
         *        Indicates whether the connector profile applies to a sandbox or production environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isSandboxEnvironment(Boolean isSandboxEnvironment);

        /**
         * <p>
         * The business unit id of Salesforce Pardot instance.
         * </p>
         * 
         * @param businessUnitId
         *        The business unit id of Salesforce Pardot instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder businessUnitId(String businessUnitId);
    }

    static final class BuilderImpl implements Builder {
        private String instanceUrl;

        private Boolean isSandboxEnvironment;

        private String businessUnitId;

        private BuilderImpl() {
        }

        private BuilderImpl(PardotConnectorProfileProperties model) {
            instanceUrl(model.instanceUrl);
            isSandboxEnvironment(model.isSandboxEnvironment);
            businessUnitId(model.businessUnitId);
        }

        public final String getInstanceUrl() {
            return instanceUrl;
        }

        public final void setInstanceUrl(String instanceUrl) {
            this.instanceUrl = instanceUrl;
        }

        @Override
        public final Builder instanceUrl(String instanceUrl) {
            this.instanceUrl = instanceUrl;
            return this;
        }

        public final Boolean getIsSandboxEnvironment() {
            return isSandboxEnvironment;
        }

        public final void setIsSandboxEnvironment(Boolean isSandboxEnvironment) {
            this.isSandboxEnvironment = isSandboxEnvironment;
        }

        @Override
        public final Builder isSandboxEnvironment(Boolean isSandboxEnvironment) {
            this.isSandboxEnvironment = isSandboxEnvironment;
            return this;
        }

        public final String getBusinessUnitId() {
            return businessUnitId;
        }

        public final void setBusinessUnitId(String businessUnitId) {
            this.businessUnitId = businessUnitId;
        }

        @Override
        public final Builder businessUnitId(String businessUnitId) {
            this.businessUnitId = businessUnitId;
            return this;
        }

        @Override
        public PardotConnectorProfileProperties build() {
            return new PardotConnectorProfileProperties(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
