/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appflow.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartFlowRequest extends AppflowRequest implements
        ToCopyableBuilder<StartFlowRequest.Builder, StartFlowRequest> {
    private static final SdkField<String> FLOW_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("flowName").getter(getter(StartFlowRequest::flowName)).setter(setter(Builder::flowName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowName").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(StartFlowRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLOW_NAME_FIELD,
            CLIENT_TOKEN_FIELD));

    private final String flowName;

    private final String clientToken;

    private StartFlowRequest(BuilderImpl builder) {
        super(builder);
        this.flowName = builder.flowName;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * The specified name of the flow. Spaces are not allowed. Use underscores (_) or hyphens (-) only.
     * </p>
     * 
     * @return The specified name of the flow. Spaces are not allowed. Use underscores (_) or hyphens (-) only.
     */
    public final String flowName() {
        return flowName;
    }

    /**
     * <p>
     * The <code>clientToken</code> parameter is an idempotency token. It ensures that your <code>StartFlow</code>
     * request completes only once. You choose the value to pass. For example, if you don't receive a response from your
     * request, you can safely retry the request with the same <code>clientToken</code> parameter value.
     * </p>
     * <p>
     * If you omit a <code>clientToken</code> value, the Amazon Web Services SDK that you are using inserts a value for
     * you. This way, the SDK can safely retry requests multiple times after a network error. You must provide your own
     * value for other use cases.
     * </p>
     * <p>
     * If you specify input parameters that differ from your first request, an error occurs for flows that run on a
     * schedule or based on an event. However, the error doesn't occur for flows that run on demand. You set the
     * conditions that initiate your flow for the <code>triggerConfig</code> parameter.
     * </p>
     * <p>
     * If you use a different value for <code>clientToken</code>, Amazon AppFlow considers it a new call to
     * <code>StartFlow</code>. The token is active for 8 hours.
     * </p>
     * 
     * @return The <code>clientToken</code> parameter is an idempotency token. It ensures that your
     *         <code>StartFlow</code> request completes only once. You choose the value to pass. For example, if you
     *         don't receive a response from your request, you can safely retry the request with the same
     *         <code>clientToken</code> parameter value.</p>
     *         <p>
     *         If you omit a <code>clientToken</code> value, the Amazon Web Services SDK that you are using inserts a
     *         value for you. This way, the SDK can safely retry requests multiple times after a network error. You must
     *         provide your own value for other use cases.
     *         </p>
     *         <p>
     *         If you specify input parameters that differ from your first request, an error occurs for flows that run
     *         on a schedule or based on an event. However, the error doesn't occur for flows that run on demand. You
     *         set the conditions that initiate your flow for the <code>triggerConfig</code> parameter.
     *         </p>
     *         <p>
     *         If you use a different value for <code>clientToken</code>, Amazon AppFlow considers it a new call to
     *         <code>StartFlow</code>. The token is active for 8 hours.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(flowName());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartFlowRequest)) {
            return false;
        }
        StartFlowRequest other = (StartFlowRequest) obj;
        return Objects.equals(flowName(), other.flowName()) && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartFlowRequest").add("FlowName", flowName()).add("ClientToken", clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "flowName":
            return Optional.ofNullable(clazz.cast(flowName()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartFlowRequest, T> g) {
        return obj -> g.apply((StartFlowRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppflowRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartFlowRequest> {
        /**
         * <p>
         * The specified name of the flow. Spaces are not allowed. Use underscores (_) or hyphens (-) only.
         * </p>
         * 
         * @param flowName
         *        The specified name of the flow. Spaces are not allowed. Use underscores (_) or hyphens (-) only.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowName(String flowName);

        /**
         * <p>
         * The <code>clientToken</code> parameter is an idempotency token. It ensures that your <code>StartFlow</code>
         * request completes only once. You choose the value to pass. For example, if you don't receive a response from
         * your request, you can safely retry the request with the same <code>clientToken</code> parameter value.
         * </p>
         * <p>
         * If you omit a <code>clientToken</code> value, the Amazon Web Services SDK that you are using inserts a value
         * for you. This way, the SDK can safely retry requests multiple times after a network error. You must provide
         * your own value for other use cases.
         * </p>
         * <p>
         * If you specify input parameters that differ from your first request, an error occurs for flows that run on a
         * schedule or based on an event. However, the error doesn't occur for flows that run on demand. You set the
         * conditions that initiate your flow for the <code>triggerConfig</code> parameter.
         * </p>
         * <p>
         * If you use a different value for <code>clientToken</code>, Amazon AppFlow considers it a new call to
         * <code>StartFlow</code>. The token is active for 8 hours.
         * </p>
         * 
         * @param clientToken
         *        The <code>clientToken</code> parameter is an idempotency token. It ensures that your
         *        <code>StartFlow</code> request completes only once. You choose the value to pass. For example, if you
         *        don't receive a response from your request, you can safely retry the request with the same
         *        <code>clientToken</code> parameter value.</p>
         *        <p>
         *        If you omit a <code>clientToken</code> value, the Amazon Web Services SDK that you are using inserts a
         *        value for you. This way, the SDK can safely retry requests multiple times after a network error. You
         *        must provide your own value for other use cases.
         *        </p>
         *        <p>
         *        If you specify input parameters that differ from your first request, an error occurs for flows that
         *        run on a schedule or based on an event. However, the error doesn't occur for flows that run on demand.
         *        You set the conditions that initiate your flow for the <code>triggerConfig</code> parameter.
         *        </p>
         *        <p>
         *        If you use a different value for <code>clientToken</code>, Amazon AppFlow considers it a new call to
         *        <code>StartFlow</code>. The token is active for 8 hours.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AppflowRequest.BuilderImpl implements Builder {
        private String flowName;

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(StartFlowRequest model) {
            super(model);
            flowName(model.flowName);
            clientToken(model.clientToken);
        }

        public final String getFlowName() {
            return flowName;
        }

        public final void setFlowName(String flowName) {
            this.flowName = flowName;
        }

        @Override
        public final Builder flowName(String flowName) {
            this.flowName = flowName;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartFlowRequest build() {
            return new StartFlowRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
