/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apprunner.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides summary information about an App Runner observability configuration resource.
 * </p>
 * <p>
 * This type contains limited information about an observability configuration. It includes only identification
 * information, without configuration details. It's returned by the <a>ListObservabilityConfigurations</a> action.
 * Complete configuration information is returned by the <a>CreateObservabilityConfiguration</a>,
 * <a>DescribeObservabilityConfiguration</a>, and <a>DeleteObservabilityConfiguration</a> actions using the
 * <a>ObservabilityConfiguration</a> type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ObservabilityConfigurationSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ObservabilityConfigurationSummary.Builder, ObservabilityConfigurationSummary> {
    private static final SdkField<String> OBSERVABILITY_CONFIGURATION_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ObservabilityConfigurationArn")
            .getter(getter(ObservabilityConfigurationSummary::observabilityConfigurationArn))
            .setter(setter(Builder::observabilityConfigurationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObservabilityConfigurationArn")
                    .build()).build();

    private static final SdkField<String> OBSERVABILITY_CONFIGURATION_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ObservabilityConfigurationName")
            .getter(getter(ObservabilityConfigurationSummary::observabilityConfigurationName))
            .setter(setter(Builder::observabilityConfigurationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObservabilityConfigurationName")
                    .build()).build();

    private static final SdkField<Integer> OBSERVABILITY_CONFIGURATION_REVISION_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("ObservabilityConfigurationRevision")
            .getter(getter(ObservabilityConfigurationSummary::observabilityConfigurationRevision))
            .setter(setter(Builder::observabilityConfigurationRevision))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObservabilityConfigurationRevision")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            OBSERVABILITY_CONFIGURATION_ARN_FIELD, OBSERVABILITY_CONFIGURATION_NAME_FIELD,
            OBSERVABILITY_CONFIGURATION_REVISION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String observabilityConfigurationArn;

    private final String observabilityConfigurationName;

    private final Integer observabilityConfigurationRevision;

    private ObservabilityConfigurationSummary(BuilderImpl builder) {
        this.observabilityConfigurationArn = builder.observabilityConfigurationArn;
        this.observabilityConfigurationName = builder.observabilityConfigurationName;
        this.observabilityConfigurationRevision = builder.observabilityConfigurationRevision;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of this observability configuration.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of this observability configuration.
     */
    public final String observabilityConfigurationArn() {
        return observabilityConfigurationArn;
    }

    /**
     * <p>
     * The customer-provided observability configuration name. It can be used in multiple revisions of a configuration.
     * </p>
     * 
     * @return The customer-provided observability configuration name. It can be used in multiple revisions of a
     *         configuration.
     */
    public final String observabilityConfigurationName() {
        return observabilityConfigurationName;
    }

    /**
     * <p>
     * The revision of this observability configuration. It's unique among all the active configurations (
     * <code>"Status": "ACTIVE"</code>) that share the same <code>ObservabilityConfigurationName</code>.
     * </p>
     * 
     * @return The revision of this observability configuration. It's unique among all the active configurations (
     *         <code>"Status": "ACTIVE"</code>) that share the same <code>ObservabilityConfigurationName</code>.
     */
    public final Integer observabilityConfigurationRevision() {
        return observabilityConfigurationRevision;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(observabilityConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(observabilityConfigurationName());
        hashCode = 31 * hashCode + Objects.hashCode(observabilityConfigurationRevision());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ObservabilityConfigurationSummary)) {
            return false;
        }
        ObservabilityConfigurationSummary other = (ObservabilityConfigurationSummary) obj;
        return Objects.equals(observabilityConfigurationArn(), other.observabilityConfigurationArn())
                && Objects.equals(observabilityConfigurationName(), other.observabilityConfigurationName())
                && Objects.equals(observabilityConfigurationRevision(), other.observabilityConfigurationRevision());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ObservabilityConfigurationSummary")
                .add("ObservabilityConfigurationArn", observabilityConfigurationArn())
                .add("ObservabilityConfigurationName", observabilityConfigurationName())
                .add("ObservabilityConfigurationRevision", observabilityConfigurationRevision()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ObservabilityConfigurationArn":
            return Optional.ofNullable(clazz.cast(observabilityConfigurationArn()));
        case "ObservabilityConfigurationName":
            return Optional.ofNullable(clazz.cast(observabilityConfigurationName()));
        case "ObservabilityConfigurationRevision":
            return Optional.ofNullable(clazz.cast(observabilityConfigurationRevision()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ObservabilityConfigurationSummary, T> g) {
        return obj -> g.apply((ObservabilityConfigurationSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ObservabilityConfigurationSummary> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of this observability configuration.
         * </p>
         * 
         * @param observabilityConfigurationArn
         *        The Amazon Resource Name (ARN) of this observability configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder observabilityConfigurationArn(String observabilityConfigurationArn);

        /**
         * <p>
         * The customer-provided observability configuration name. It can be used in multiple revisions of a
         * configuration.
         * </p>
         * 
         * @param observabilityConfigurationName
         *        The customer-provided observability configuration name. It can be used in multiple revisions of a
         *        configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder observabilityConfigurationName(String observabilityConfigurationName);

        /**
         * <p>
         * The revision of this observability configuration. It's unique among all the active configurations (
         * <code>"Status": "ACTIVE"</code>) that share the same <code>ObservabilityConfigurationName</code>.
         * </p>
         * 
         * @param observabilityConfigurationRevision
         *        The revision of this observability configuration. It's unique among all the active configurations (
         *        <code>"Status": "ACTIVE"</code>) that share the same <code>ObservabilityConfigurationName</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder observabilityConfigurationRevision(Integer observabilityConfigurationRevision);
    }

    static final class BuilderImpl implements Builder {
        private String observabilityConfigurationArn;

        private String observabilityConfigurationName;

        private Integer observabilityConfigurationRevision;

        private BuilderImpl() {
        }

        private BuilderImpl(ObservabilityConfigurationSummary model) {
            observabilityConfigurationArn(model.observabilityConfigurationArn);
            observabilityConfigurationName(model.observabilityConfigurationName);
            observabilityConfigurationRevision(model.observabilityConfigurationRevision);
        }

        public final String getObservabilityConfigurationArn() {
            return observabilityConfigurationArn;
        }

        public final void setObservabilityConfigurationArn(String observabilityConfigurationArn) {
            this.observabilityConfigurationArn = observabilityConfigurationArn;
        }

        @Override
        public final Builder observabilityConfigurationArn(String observabilityConfigurationArn) {
            this.observabilityConfigurationArn = observabilityConfigurationArn;
            return this;
        }

        public final String getObservabilityConfigurationName() {
            return observabilityConfigurationName;
        }

        public final void setObservabilityConfigurationName(String observabilityConfigurationName) {
            this.observabilityConfigurationName = observabilityConfigurationName;
        }

        @Override
        public final Builder observabilityConfigurationName(String observabilityConfigurationName) {
            this.observabilityConfigurationName = observabilityConfigurationName;
            return this;
        }

        public final Integer getObservabilityConfigurationRevision() {
            return observabilityConfigurationRevision;
        }

        public final void setObservabilityConfigurationRevision(Integer observabilityConfigurationRevision) {
            this.observabilityConfigurationRevision = observabilityConfigurationRevision;
        }

        @Override
        public final Builder observabilityConfigurationRevision(Integer observabilityConfigurationRevision) {
            this.observabilityConfigurationRevision = observabilityConfigurationRevision;
            return this;
        }

        @Override
        public ObservabilityConfigurationSummary build() {
            return new ObservabilityConfigurationSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
