/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appsync.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDataSourceRequest extends AppSyncRequest implements
        ToCopyableBuilder<CreateDataSourceRequest.Builder, CreateDataSourceRequest> {
    private static final SdkField<String> API_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("apiId")
            .getter(getter(CreateDataSourceRequest::apiId)).setter(setter(Builder::apiId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("apiId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateDataSourceRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateDataSourceRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(CreateDataSourceRequest::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<String> SERVICE_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serviceRoleArn").getter(getter(CreateDataSourceRequest::serviceRoleArn))
            .setter(setter(Builder::serviceRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceRoleArn").build()).build();

    private static final SdkField<DynamodbDataSourceConfig> DYNAMODB_CONFIG_FIELD = SdkField
            .<DynamodbDataSourceConfig> builder(MarshallingType.SDK_POJO).memberName("dynamodbConfig")
            .getter(getter(CreateDataSourceRequest::dynamodbConfig)).setter(setter(Builder::dynamodbConfig))
            .constructor(DynamodbDataSourceConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dynamodbConfig").build()).build();

    private static final SdkField<LambdaDataSourceConfig> LAMBDA_CONFIG_FIELD = SdkField
            .<LambdaDataSourceConfig> builder(MarshallingType.SDK_POJO).memberName("lambdaConfig")
            .getter(getter(CreateDataSourceRequest::lambdaConfig)).setter(setter(Builder::lambdaConfig))
            .constructor(LambdaDataSourceConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lambdaConfig").build()).build();

    private static final SdkField<ElasticsearchDataSourceConfig> ELASTICSEARCH_CONFIG_FIELD = SdkField
            .<ElasticsearchDataSourceConfig> builder(MarshallingType.SDK_POJO).memberName("elasticsearchConfig")
            .getter(getter(CreateDataSourceRequest::elasticsearchConfig)).setter(setter(Builder::elasticsearchConfig))
            .constructor(ElasticsearchDataSourceConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("elasticsearchConfig").build())
            .build();

    private static final SdkField<OpenSearchServiceDataSourceConfig> OPEN_SEARCH_SERVICE_CONFIG_FIELD = SdkField
            .<OpenSearchServiceDataSourceConfig> builder(MarshallingType.SDK_POJO).memberName("openSearchServiceConfig")
            .getter(getter(CreateDataSourceRequest::openSearchServiceConfig)).setter(setter(Builder::openSearchServiceConfig))
            .constructor(OpenSearchServiceDataSourceConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("openSearchServiceConfig").build())
            .build();

    private static final SdkField<HttpDataSourceConfig> HTTP_CONFIG_FIELD = SdkField
            .<HttpDataSourceConfig> builder(MarshallingType.SDK_POJO).memberName("httpConfig")
            .getter(getter(CreateDataSourceRequest::httpConfig)).setter(setter(Builder::httpConfig))
            .constructor(HttpDataSourceConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("httpConfig").build()).build();

    private static final SdkField<RelationalDatabaseDataSourceConfig> RELATIONAL_DATABASE_CONFIG_FIELD = SdkField
            .<RelationalDatabaseDataSourceConfig> builder(MarshallingType.SDK_POJO).memberName("relationalDatabaseConfig")
            .getter(getter(CreateDataSourceRequest::relationalDatabaseConfig)).setter(setter(Builder::relationalDatabaseConfig))
            .constructor(RelationalDatabaseDataSourceConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relationalDatabaseConfig").build())
            .build();

    private static final SdkField<EventBridgeDataSourceConfig> EVENT_BRIDGE_CONFIG_FIELD = SdkField
            .<EventBridgeDataSourceConfig> builder(MarshallingType.SDK_POJO).memberName("eventBridgeConfig")
            .getter(getter(CreateDataSourceRequest::eventBridgeConfig)).setter(setter(Builder::eventBridgeConfig))
            .constructor(EventBridgeDataSourceConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventBridgeConfig").build()).build();

    private static final SdkField<String> METRICS_CONFIG_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("metricsConfig").getter(getter(CreateDataSourceRequest::metricsConfigAsString))
            .setter(setter(Builder::metricsConfig))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricsConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(API_ID_FIELD, NAME_FIELD,
            DESCRIPTION_FIELD, TYPE_FIELD, SERVICE_ROLE_ARN_FIELD, DYNAMODB_CONFIG_FIELD, LAMBDA_CONFIG_FIELD,
            ELASTICSEARCH_CONFIG_FIELD, OPEN_SEARCH_SERVICE_CONFIG_FIELD, HTTP_CONFIG_FIELD, RELATIONAL_DATABASE_CONFIG_FIELD,
            EVENT_BRIDGE_CONFIG_FIELD, METRICS_CONFIG_FIELD));

    private final String apiId;

    private final String name;

    private final String description;

    private final String type;

    private final String serviceRoleArn;

    private final DynamodbDataSourceConfig dynamodbConfig;

    private final LambdaDataSourceConfig lambdaConfig;

    private final ElasticsearchDataSourceConfig elasticsearchConfig;

    private final OpenSearchServiceDataSourceConfig openSearchServiceConfig;

    private final HttpDataSourceConfig httpConfig;

    private final RelationalDatabaseDataSourceConfig relationalDatabaseConfig;

    private final EventBridgeDataSourceConfig eventBridgeConfig;

    private final String metricsConfig;

    private CreateDataSourceRequest(BuilderImpl builder) {
        super(builder);
        this.apiId = builder.apiId;
        this.name = builder.name;
        this.description = builder.description;
        this.type = builder.type;
        this.serviceRoleArn = builder.serviceRoleArn;
        this.dynamodbConfig = builder.dynamodbConfig;
        this.lambdaConfig = builder.lambdaConfig;
        this.elasticsearchConfig = builder.elasticsearchConfig;
        this.openSearchServiceConfig = builder.openSearchServiceConfig;
        this.httpConfig = builder.httpConfig;
        this.relationalDatabaseConfig = builder.relationalDatabaseConfig;
        this.eventBridgeConfig = builder.eventBridgeConfig;
        this.metricsConfig = builder.metricsConfig;
    }

    /**
     * <p>
     * The API ID for the GraphQL API for the <code>DataSource</code>.
     * </p>
     * 
     * @return The API ID for the GraphQL API for the <code>DataSource</code>.
     */
    public final String apiId() {
        return apiId;
    }

    /**
     * <p>
     * A user-supplied name for the <code>DataSource</code>.
     * </p>
     * 
     * @return A user-supplied name for the <code>DataSource</code>.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A description of the <code>DataSource</code>.
     * </p>
     * 
     * @return A description of the <code>DataSource</code>.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The type of the <code>DataSource</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link DataSourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the <code>DataSource</code>.
     * @see DataSourceType
     */
    public final DataSourceType type() {
        return DataSourceType.fromValue(type);
    }

    /**
     * <p>
     * The type of the <code>DataSource</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link DataSourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the <code>DataSource</code>.
     * @see DataSourceType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The Identity and Access Management (IAM) service role Amazon Resource Name (ARN) for the data source. The system
     * assumes this role when accessing the data source.
     * </p>
     * 
     * @return The Identity and Access Management (IAM) service role Amazon Resource Name (ARN) for the data source. The
     *         system assumes this role when accessing the data source.
     */
    public final String serviceRoleArn() {
        return serviceRoleArn;
    }

    /**
     * <p>
     * Amazon DynamoDB settings.
     * </p>
     * 
     * @return Amazon DynamoDB settings.
     */
    public final DynamodbDataSourceConfig dynamodbConfig() {
        return dynamodbConfig;
    }

    /**
     * <p>
     * Lambda settings.
     * </p>
     * 
     * @return Lambda settings.
     */
    public final LambdaDataSourceConfig lambdaConfig() {
        return lambdaConfig;
    }

    /**
     * <p>
     * Amazon OpenSearch Service settings.
     * </p>
     * <p>
     * As of September 2021, Amazon Elasticsearch service is Amazon OpenSearch Service. This configuration is
     * deprecated. For new data sources, use <a>CreateDataSourceRequest$openSearchServiceConfig</a> to create an
     * OpenSearch data source.
     * </p>
     * 
     * @return Amazon OpenSearch Service settings.</p>
     *         <p>
     *         As of September 2021, Amazon Elasticsearch service is Amazon OpenSearch Service. This configuration is
     *         deprecated. For new data sources, use <a>CreateDataSourceRequest$openSearchServiceConfig</a> to create an
     *         OpenSearch data source.
     */
    public final ElasticsearchDataSourceConfig elasticsearchConfig() {
        return elasticsearchConfig;
    }

    /**
     * <p>
     * Amazon OpenSearch Service settings.
     * </p>
     * 
     * @return Amazon OpenSearch Service settings.
     */
    public final OpenSearchServiceDataSourceConfig openSearchServiceConfig() {
        return openSearchServiceConfig;
    }

    /**
     * <p>
     * HTTP endpoint settings.
     * </p>
     * 
     * @return HTTP endpoint settings.
     */
    public final HttpDataSourceConfig httpConfig() {
        return httpConfig;
    }

    /**
     * <p>
     * Relational database settings.
     * </p>
     * 
     * @return Relational database settings.
     */
    public final RelationalDatabaseDataSourceConfig relationalDatabaseConfig() {
        return relationalDatabaseConfig;
    }

    /**
     * <p>
     * Amazon EventBridge settings.
     * </p>
     * 
     * @return Amazon EventBridge settings.
     */
    public final EventBridgeDataSourceConfig eventBridgeConfig() {
        return eventBridgeConfig;
    }

    /**
     * <p>
     * Enables or disables enhanced data source metrics for specified data sources. Note that <code>metricsConfig</code>
     * won't be used unless the <code>dataSourceLevelMetricsBehavior</code> value is set to
     * <code>PER_DATA_SOURCE_METRICS</code>. If the <code>dataSourceLevelMetricsBehavior</code> is set to
     * <code>FULL_REQUEST_DATA_SOURCE_METRICS</code> instead, <code>metricsConfig</code> will be ignored. However, you
     * can still set its value.
     * </p>
     * <p>
     * <code>metricsConfig</code> can be <code>ENABLED</code> or <code>DISABLED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #metricsConfig}
     * will return {@link DataSourceLevelMetricsConfig#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #metricsConfigAsString}.
     * </p>
     * 
     * @return Enables or disables enhanced data source metrics for specified data sources. Note that
     *         <code>metricsConfig</code> won't be used unless the <code>dataSourceLevelMetricsBehavior</code> value is
     *         set to <code>PER_DATA_SOURCE_METRICS</code>. If the <code>dataSourceLevelMetricsBehavior</code> is set to
     *         <code>FULL_REQUEST_DATA_SOURCE_METRICS</code> instead, <code>metricsConfig</code> will be ignored.
     *         However, you can still set its value.</p>
     *         <p>
     *         <code>metricsConfig</code> can be <code>ENABLED</code> or <code>DISABLED</code>.
     * @see DataSourceLevelMetricsConfig
     */
    public final DataSourceLevelMetricsConfig metricsConfig() {
        return DataSourceLevelMetricsConfig.fromValue(metricsConfig);
    }

    /**
     * <p>
     * Enables or disables enhanced data source metrics for specified data sources. Note that <code>metricsConfig</code>
     * won't be used unless the <code>dataSourceLevelMetricsBehavior</code> value is set to
     * <code>PER_DATA_SOURCE_METRICS</code>. If the <code>dataSourceLevelMetricsBehavior</code> is set to
     * <code>FULL_REQUEST_DATA_SOURCE_METRICS</code> instead, <code>metricsConfig</code> will be ignored. However, you
     * can still set its value.
     * </p>
     * <p>
     * <code>metricsConfig</code> can be <code>ENABLED</code> or <code>DISABLED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #metricsConfig}
     * will return {@link DataSourceLevelMetricsConfig#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #metricsConfigAsString}.
     * </p>
     * 
     * @return Enables or disables enhanced data source metrics for specified data sources. Note that
     *         <code>metricsConfig</code> won't be used unless the <code>dataSourceLevelMetricsBehavior</code> value is
     *         set to <code>PER_DATA_SOURCE_METRICS</code>. If the <code>dataSourceLevelMetricsBehavior</code> is set to
     *         <code>FULL_REQUEST_DATA_SOURCE_METRICS</code> instead, <code>metricsConfig</code> will be ignored.
     *         However, you can still set its value.</p>
     *         <p>
     *         <code>metricsConfig</code> can be <code>ENABLED</code> or <code>DISABLED</code>.
     * @see DataSourceLevelMetricsConfig
     */
    public final String metricsConfigAsString() {
        return metricsConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(apiId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(serviceRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(dynamodbConfig());
        hashCode = 31 * hashCode + Objects.hashCode(lambdaConfig());
        hashCode = 31 * hashCode + Objects.hashCode(elasticsearchConfig());
        hashCode = 31 * hashCode + Objects.hashCode(openSearchServiceConfig());
        hashCode = 31 * hashCode + Objects.hashCode(httpConfig());
        hashCode = 31 * hashCode + Objects.hashCode(relationalDatabaseConfig());
        hashCode = 31 * hashCode + Objects.hashCode(eventBridgeConfig());
        hashCode = 31 * hashCode + Objects.hashCode(metricsConfigAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDataSourceRequest)) {
            return false;
        }
        CreateDataSourceRequest other = (CreateDataSourceRequest) obj;
        return Objects.equals(apiId(), other.apiId()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(serviceRoleArn(), other.serviceRoleArn())
                && Objects.equals(dynamodbConfig(), other.dynamodbConfig())
                && Objects.equals(lambdaConfig(), other.lambdaConfig())
                && Objects.equals(elasticsearchConfig(), other.elasticsearchConfig())
                && Objects.equals(openSearchServiceConfig(), other.openSearchServiceConfig())
                && Objects.equals(httpConfig(), other.httpConfig())
                && Objects.equals(relationalDatabaseConfig(), other.relationalDatabaseConfig())
                && Objects.equals(eventBridgeConfig(), other.eventBridgeConfig())
                && Objects.equals(metricsConfigAsString(), other.metricsConfigAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateDataSourceRequest").add("ApiId", apiId()).add("Name", name())
                .add("Description", description()).add("Type", typeAsString()).add("ServiceRoleArn", serviceRoleArn())
                .add("DynamodbConfig", dynamodbConfig()).add("LambdaConfig", lambdaConfig())
                .add("ElasticsearchConfig", elasticsearchConfig()).add("OpenSearchServiceConfig", openSearchServiceConfig())
                .add("HttpConfig", httpConfig()).add("RelationalDatabaseConfig", relationalDatabaseConfig())
                .add("EventBridgeConfig", eventBridgeConfig()).add("MetricsConfig", metricsConfigAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "apiId":
            return Optional.ofNullable(clazz.cast(apiId()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "serviceRoleArn":
            return Optional.ofNullable(clazz.cast(serviceRoleArn()));
        case "dynamodbConfig":
            return Optional.ofNullable(clazz.cast(dynamodbConfig()));
        case "lambdaConfig":
            return Optional.ofNullable(clazz.cast(lambdaConfig()));
        case "elasticsearchConfig":
            return Optional.ofNullable(clazz.cast(elasticsearchConfig()));
        case "openSearchServiceConfig":
            return Optional.ofNullable(clazz.cast(openSearchServiceConfig()));
        case "httpConfig":
            return Optional.ofNullable(clazz.cast(httpConfig()));
        case "relationalDatabaseConfig":
            return Optional.ofNullable(clazz.cast(relationalDatabaseConfig()));
        case "eventBridgeConfig":
            return Optional.ofNullable(clazz.cast(eventBridgeConfig()));
        case "metricsConfig":
            return Optional.ofNullable(clazz.cast(metricsConfigAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDataSourceRequest, T> g) {
        return obj -> g.apply((CreateDataSourceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppSyncRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateDataSourceRequest> {
        /**
         * <p>
         * The API ID for the GraphQL API for the <code>DataSource</code>.
         * </p>
         * 
         * @param apiId
         *        The API ID for the GraphQL API for the <code>DataSource</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apiId(String apiId);

        /**
         * <p>
         * A user-supplied name for the <code>DataSource</code>.
         * </p>
         * 
         * @param name
         *        A user-supplied name for the <code>DataSource</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A description of the <code>DataSource</code>.
         * </p>
         * 
         * @param description
         *        A description of the <code>DataSource</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The type of the <code>DataSource</code>.
         * </p>
         * 
         * @param type
         *        The type of the <code>DataSource</code>.
         * @see DataSourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataSourceType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of the <code>DataSource</code>.
         * </p>
         * 
         * @param type
         *        The type of the <code>DataSource</code>.
         * @see DataSourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataSourceType
         */
        Builder type(DataSourceType type);

        /**
         * <p>
         * The Identity and Access Management (IAM) service role Amazon Resource Name (ARN) for the data source. The
         * system assumes this role when accessing the data source.
         * </p>
         * 
         * @param serviceRoleArn
         *        The Identity and Access Management (IAM) service role Amazon Resource Name (ARN) for the data source.
         *        The system assumes this role when accessing the data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceRoleArn(String serviceRoleArn);

        /**
         * <p>
         * Amazon DynamoDB settings.
         * </p>
         * 
         * @param dynamodbConfig
         *        Amazon DynamoDB settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dynamodbConfig(DynamodbDataSourceConfig dynamodbConfig);

        /**
         * <p>
         * Amazon DynamoDB settings.
         * </p>
         * This is a convenience method that creates an instance of the {@link DynamodbDataSourceConfig.Builder}
         * avoiding the need to create one manually via {@link DynamodbDataSourceConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DynamodbDataSourceConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #dynamodbConfig(DynamodbDataSourceConfig)}.
         * 
         * @param dynamodbConfig
         *        a consumer that will call methods on {@link DynamodbDataSourceConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dynamodbConfig(DynamodbDataSourceConfig)
         */
        default Builder dynamodbConfig(Consumer<DynamodbDataSourceConfig.Builder> dynamodbConfig) {
            return dynamodbConfig(DynamodbDataSourceConfig.builder().applyMutation(dynamodbConfig).build());
        }

        /**
         * <p>
         * Lambda settings.
         * </p>
         * 
         * @param lambdaConfig
         *        Lambda settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lambdaConfig(LambdaDataSourceConfig lambdaConfig);

        /**
         * <p>
         * Lambda settings.
         * </p>
         * This is a convenience method that creates an instance of the {@link LambdaDataSourceConfig.Builder} avoiding
         * the need to create one manually via {@link LambdaDataSourceConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LambdaDataSourceConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #lambdaConfig(LambdaDataSourceConfig)}.
         * 
         * @param lambdaConfig
         *        a consumer that will call methods on {@link LambdaDataSourceConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lambdaConfig(LambdaDataSourceConfig)
         */
        default Builder lambdaConfig(Consumer<LambdaDataSourceConfig.Builder> lambdaConfig) {
            return lambdaConfig(LambdaDataSourceConfig.builder().applyMutation(lambdaConfig).build());
        }

        /**
         * <p>
         * Amazon OpenSearch Service settings.
         * </p>
         * <p>
         * As of September 2021, Amazon Elasticsearch service is Amazon OpenSearch Service. This configuration is
         * deprecated. For new data sources, use <a>CreateDataSourceRequest$openSearchServiceConfig</a> to create an
         * OpenSearch data source.
         * </p>
         * 
         * @param elasticsearchConfig
         *        Amazon OpenSearch Service settings.</p>
         *        <p>
         *        As of September 2021, Amazon Elasticsearch service is Amazon OpenSearch Service. This configuration is
         *        deprecated. For new data sources, use <a>CreateDataSourceRequest$openSearchServiceConfig</a> to create
         *        an OpenSearch data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elasticsearchConfig(ElasticsearchDataSourceConfig elasticsearchConfig);

        /**
         * <p>
         * Amazon OpenSearch Service settings.
         * </p>
         * <p>
         * As of September 2021, Amazon Elasticsearch service is Amazon OpenSearch Service. This configuration is
         * deprecated. For new data sources, use <a>CreateDataSourceRequest$openSearchServiceConfig</a> to create an
         * OpenSearch data source.
         * </p>
         * This is a convenience method that creates an instance of the {@link ElasticsearchDataSourceConfig.Builder}
         * avoiding the need to create one manually via {@link ElasticsearchDataSourceConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ElasticsearchDataSourceConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #elasticsearchConfig(ElasticsearchDataSourceConfig)}.
         * 
         * @param elasticsearchConfig
         *        a consumer that will call methods on {@link ElasticsearchDataSourceConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #elasticsearchConfig(ElasticsearchDataSourceConfig)
         */
        default Builder elasticsearchConfig(Consumer<ElasticsearchDataSourceConfig.Builder> elasticsearchConfig) {
            return elasticsearchConfig(ElasticsearchDataSourceConfig.builder().applyMutation(elasticsearchConfig).build());
        }

        /**
         * <p>
         * Amazon OpenSearch Service settings.
         * </p>
         * 
         * @param openSearchServiceConfig
         *        Amazon OpenSearch Service settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder openSearchServiceConfig(OpenSearchServiceDataSourceConfig openSearchServiceConfig);

        /**
         * <p>
         * Amazon OpenSearch Service settings.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link OpenSearchServiceDataSourceConfig.Builder} avoiding the need to create one manually via
         * {@link OpenSearchServiceDataSourceConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OpenSearchServiceDataSourceConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #openSearchServiceConfig(OpenSearchServiceDataSourceConfig)}.
         * 
         * @param openSearchServiceConfig
         *        a consumer that will call methods on {@link OpenSearchServiceDataSourceConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #openSearchServiceConfig(OpenSearchServiceDataSourceConfig)
         */
        default Builder openSearchServiceConfig(Consumer<OpenSearchServiceDataSourceConfig.Builder> openSearchServiceConfig) {
            return openSearchServiceConfig(OpenSearchServiceDataSourceConfig.builder().applyMutation(openSearchServiceConfig)
                    .build());
        }

        /**
         * <p>
         * HTTP endpoint settings.
         * </p>
         * 
         * @param httpConfig
         *        HTTP endpoint settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder httpConfig(HttpDataSourceConfig httpConfig);

        /**
         * <p>
         * HTTP endpoint settings.
         * </p>
         * This is a convenience method that creates an instance of the {@link HttpDataSourceConfig.Builder} avoiding
         * the need to create one manually via {@link HttpDataSourceConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link HttpDataSourceConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #httpConfig(HttpDataSourceConfig)}.
         * 
         * @param httpConfig
         *        a consumer that will call methods on {@link HttpDataSourceConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #httpConfig(HttpDataSourceConfig)
         */
        default Builder httpConfig(Consumer<HttpDataSourceConfig.Builder> httpConfig) {
            return httpConfig(HttpDataSourceConfig.builder().applyMutation(httpConfig).build());
        }

        /**
         * <p>
         * Relational database settings.
         * </p>
         * 
         * @param relationalDatabaseConfig
         *        Relational database settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relationalDatabaseConfig(RelationalDatabaseDataSourceConfig relationalDatabaseConfig);

        /**
         * <p>
         * Relational database settings.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link RelationalDatabaseDataSourceConfig.Builder} avoiding the need to create one manually via
         * {@link RelationalDatabaseDataSourceConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RelationalDatabaseDataSourceConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #relationalDatabaseConfig(RelationalDatabaseDataSourceConfig)}.
         * 
         * @param relationalDatabaseConfig
         *        a consumer that will call methods on {@link RelationalDatabaseDataSourceConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #relationalDatabaseConfig(RelationalDatabaseDataSourceConfig)
         */
        default Builder relationalDatabaseConfig(Consumer<RelationalDatabaseDataSourceConfig.Builder> relationalDatabaseConfig) {
            return relationalDatabaseConfig(RelationalDatabaseDataSourceConfig.builder().applyMutation(relationalDatabaseConfig)
                    .build());
        }

        /**
         * <p>
         * Amazon EventBridge settings.
         * </p>
         * 
         * @param eventBridgeConfig
         *        Amazon EventBridge settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventBridgeConfig(EventBridgeDataSourceConfig eventBridgeConfig);

        /**
         * <p>
         * Amazon EventBridge settings.
         * </p>
         * This is a convenience method that creates an instance of the {@link EventBridgeDataSourceConfig.Builder}
         * avoiding the need to create one manually via {@link EventBridgeDataSourceConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EventBridgeDataSourceConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #eventBridgeConfig(EventBridgeDataSourceConfig)}.
         * 
         * @param eventBridgeConfig
         *        a consumer that will call methods on {@link EventBridgeDataSourceConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #eventBridgeConfig(EventBridgeDataSourceConfig)
         */
        default Builder eventBridgeConfig(Consumer<EventBridgeDataSourceConfig.Builder> eventBridgeConfig) {
            return eventBridgeConfig(EventBridgeDataSourceConfig.builder().applyMutation(eventBridgeConfig).build());
        }

        /**
         * <p>
         * Enables or disables enhanced data source metrics for specified data sources. Note that
         * <code>metricsConfig</code> won't be used unless the <code>dataSourceLevelMetricsBehavior</code> value is set
         * to <code>PER_DATA_SOURCE_METRICS</code>. If the <code>dataSourceLevelMetricsBehavior</code> is set to
         * <code>FULL_REQUEST_DATA_SOURCE_METRICS</code> instead, <code>metricsConfig</code> will be ignored. However,
         * you can still set its value.
         * </p>
         * <p>
         * <code>metricsConfig</code> can be <code>ENABLED</code> or <code>DISABLED</code>.
         * </p>
         * 
         * @param metricsConfig
         *        Enables or disables enhanced data source metrics for specified data sources. Note that
         *        <code>metricsConfig</code> won't be used unless the <code>dataSourceLevelMetricsBehavior</code> value
         *        is set to <code>PER_DATA_SOURCE_METRICS</code>. If the <code>dataSourceLevelMetricsBehavior</code> is
         *        set to <code>FULL_REQUEST_DATA_SOURCE_METRICS</code> instead, <code>metricsConfig</code> will be
         *        ignored. However, you can still set its value.</p>
         *        <p>
         *        <code>metricsConfig</code> can be <code>ENABLED</code> or <code>DISABLED</code>.
         * @see DataSourceLevelMetricsConfig
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataSourceLevelMetricsConfig
         */
        Builder metricsConfig(String metricsConfig);

        /**
         * <p>
         * Enables or disables enhanced data source metrics for specified data sources. Note that
         * <code>metricsConfig</code> won't be used unless the <code>dataSourceLevelMetricsBehavior</code> value is set
         * to <code>PER_DATA_SOURCE_METRICS</code>. If the <code>dataSourceLevelMetricsBehavior</code> is set to
         * <code>FULL_REQUEST_DATA_SOURCE_METRICS</code> instead, <code>metricsConfig</code> will be ignored. However,
         * you can still set its value.
         * </p>
         * <p>
         * <code>metricsConfig</code> can be <code>ENABLED</code> or <code>DISABLED</code>.
         * </p>
         * 
         * @param metricsConfig
         *        Enables or disables enhanced data source metrics for specified data sources. Note that
         *        <code>metricsConfig</code> won't be used unless the <code>dataSourceLevelMetricsBehavior</code> value
         *        is set to <code>PER_DATA_SOURCE_METRICS</code>. If the <code>dataSourceLevelMetricsBehavior</code> is
         *        set to <code>FULL_REQUEST_DATA_SOURCE_METRICS</code> instead, <code>metricsConfig</code> will be
         *        ignored. However, you can still set its value.</p>
         *        <p>
         *        <code>metricsConfig</code> can be <code>ENABLED</code> or <code>DISABLED</code>.
         * @see DataSourceLevelMetricsConfig
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataSourceLevelMetricsConfig
         */
        Builder metricsConfig(DataSourceLevelMetricsConfig metricsConfig);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AppSyncRequest.BuilderImpl implements Builder {
        private String apiId;

        private String name;

        private String description;

        private String type;

        private String serviceRoleArn;

        private DynamodbDataSourceConfig dynamodbConfig;

        private LambdaDataSourceConfig lambdaConfig;

        private ElasticsearchDataSourceConfig elasticsearchConfig;

        private OpenSearchServiceDataSourceConfig openSearchServiceConfig;

        private HttpDataSourceConfig httpConfig;

        private RelationalDatabaseDataSourceConfig relationalDatabaseConfig;

        private EventBridgeDataSourceConfig eventBridgeConfig;

        private String metricsConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDataSourceRequest model) {
            super(model);
            apiId(model.apiId);
            name(model.name);
            description(model.description);
            type(model.type);
            serviceRoleArn(model.serviceRoleArn);
            dynamodbConfig(model.dynamodbConfig);
            lambdaConfig(model.lambdaConfig);
            elasticsearchConfig(model.elasticsearchConfig);
            openSearchServiceConfig(model.openSearchServiceConfig);
            httpConfig(model.httpConfig);
            relationalDatabaseConfig(model.relationalDatabaseConfig);
            eventBridgeConfig(model.eventBridgeConfig);
            metricsConfig(model.metricsConfig);
        }

        public final String getApiId() {
            return apiId;
        }

        public final void setApiId(String apiId) {
            this.apiId = apiId;
        }

        @Override
        public final Builder apiId(String apiId) {
            this.apiId = apiId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(DataSourceType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getServiceRoleArn() {
            return serviceRoleArn;
        }

        public final void setServiceRoleArn(String serviceRoleArn) {
            this.serviceRoleArn = serviceRoleArn;
        }

        @Override
        public final Builder serviceRoleArn(String serviceRoleArn) {
            this.serviceRoleArn = serviceRoleArn;
            return this;
        }

        public final DynamodbDataSourceConfig.Builder getDynamodbConfig() {
            return dynamodbConfig != null ? dynamodbConfig.toBuilder() : null;
        }

        public final void setDynamodbConfig(DynamodbDataSourceConfig.BuilderImpl dynamodbConfig) {
            this.dynamodbConfig = dynamodbConfig != null ? dynamodbConfig.build() : null;
        }

        @Override
        public final Builder dynamodbConfig(DynamodbDataSourceConfig dynamodbConfig) {
            this.dynamodbConfig = dynamodbConfig;
            return this;
        }

        public final LambdaDataSourceConfig.Builder getLambdaConfig() {
            return lambdaConfig != null ? lambdaConfig.toBuilder() : null;
        }

        public final void setLambdaConfig(LambdaDataSourceConfig.BuilderImpl lambdaConfig) {
            this.lambdaConfig = lambdaConfig != null ? lambdaConfig.build() : null;
        }

        @Override
        public final Builder lambdaConfig(LambdaDataSourceConfig lambdaConfig) {
            this.lambdaConfig = lambdaConfig;
            return this;
        }

        public final ElasticsearchDataSourceConfig.Builder getElasticsearchConfig() {
            return elasticsearchConfig != null ? elasticsearchConfig.toBuilder() : null;
        }

        public final void setElasticsearchConfig(ElasticsearchDataSourceConfig.BuilderImpl elasticsearchConfig) {
            this.elasticsearchConfig = elasticsearchConfig != null ? elasticsearchConfig.build() : null;
        }

        @Override
        public final Builder elasticsearchConfig(ElasticsearchDataSourceConfig elasticsearchConfig) {
            this.elasticsearchConfig = elasticsearchConfig;
            return this;
        }

        public final OpenSearchServiceDataSourceConfig.Builder getOpenSearchServiceConfig() {
            return openSearchServiceConfig != null ? openSearchServiceConfig.toBuilder() : null;
        }

        public final void setOpenSearchServiceConfig(OpenSearchServiceDataSourceConfig.BuilderImpl openSearchServiceConfig) {
            this.openSearchServiceConfig = openSearchServiceConfig != null ? openSearchServiceConfig.build() : null;
        }

        @Override
        public final Builder openSearchServiceConfig(OpenSearchServiceDataSourceConfig openSearchServiceConfig) {
            this.openSearchServiceConfig = openSearchServiceConfig;
            return this;
        }

        public final HttpDataSourceConfig.Builder getHttpConfig() {
            return httpConfig != null ? httpConfig.toBuilder() : null;
        }

        public final void setHttpConfig(HttpDataSourceConfig.BuilderImpl httpConfig) {
            this.httpConfig = httpConfig != null ? httpConfig.build() : null;
        }

        @Override
        public final Builder httpConfig(HttpDataSourceConfig httpConfig) {
            this.httpConfig = httpConfig;
            return this;
        }

        public final RelationalDatabaseDataSourceConfig.Builder getRelationalDatabaseConfig() {
            return relationalDatabaseConfig != null ? relationalDatabaseConfig.toBuilder() : null;
        }

        public final void setRelationalDatabaseConfig(RelationalDatabaseDataSourceConfig.BuilderImpl relationalDatabaseConfig) {
            this.relationalDatabaseConfig = relationalDatabaseConfig != null ? relationalDatabaseConfig.build() : null;
        }

        @Override
        public final Builder relationalDatabaseConfig(RelationalDatabaseDataSourceConfig relationalDatabaseConfig) {
            this.relationalDatabaseConfig = relationalDatabaseConfig;
            return this;
        }

        public final EventBridgeDataSourceConfig.Builder getEventBridgeConfig() {
            return eventBridgeConfig != null ? eventBridgeConfig.toBuilder() : null;
        }

        public final void setEventBridgeConfig(EventBridgeDataSourceConfig.BuilderImpl eventBridgeConfig) {
            this.eventBridgeConfig = eventBridgeConfig != null ? eventBridgeConfig.build() : null;
        }

        @Override
        public final Builder eventBridgeConfig(EventBridgeDataSourceConfig eventBridgeConfig) {
            this.eventBridgeConfig = eventBridgeConfig;
            return this;
        }

        public final String getMetricsConfig() {
            return metricsConfig;
        }

        public final void setMetricsConfig(String metricsConfig) {
            this.metricsConfig = metricsConfig;
        }

        @Override
        public final Builder metricsConfig(String metricsConfig) {
            this.metricsConfig = metricsConfig;
            return this;
        }

        @Override
        public final Builder metricsConfig(DataSourceLevelMetricsConfig metricsConfig) {
            this.metricsConfig(metricsConfig == null ? null : metricsConfig.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDataSourceRequest build() {
            return new CreateDataSourceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
