/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apptest.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.apptest.model.AppTestResponse;
import software.amazon.awssdk.services.apptest.model.TestRunStepSummary;
import software.amazon.awssdk.services.apptest.model.TestRunStepSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListTestRunStepsResponse
extends AppTestResponse
implements ToCopyableBuilder<Builder, ListTestRunStepsResponse> {
    private static final SdkField<List<TestRunStepSummary>> TEST_RUN_STEPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("testRunSteps").getter(ListTestRunStepsResponse.getter(ListTestRunStepsResponse::testRunSteps)).setter(ListTestRunStepsResponse.setter(Builder::testRunSteps)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testRunSteps").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TestRunStepSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListTestRunStepsResponse.getter(ListTestRunStepsResponse::nextToken)).setter(ListTestRunStepsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEST_RUN_STEPS_FIELD, NEXT_TOKEN_FIELD));
    private final List<TestRunStepSummary> testRunSteps;
    private final String nextToken;

    private ListTestRunStepsResponse(BuilderImpl builder) {
        super(builder);
        this.testRunSteps = builder.testRunSteps;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasTestRunSteps() {
        return this.testRunSteps != null && !(this.testRunSteps instanceof SdkAutoConstructList);
    }

    public final List<TestRunStepSummary> testRunSteps() {
        return this.testRunSteps;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTestRunSteps() ? this.testRunSteps() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTestRunStepsResponse)) {
            return false;
        }
        ListTestRunStepsResponse other = (ListTestRunStepsResponse)((Object)obj);
        return this.hasTestRunSteps() == other.hasTestRunSteps() && Objects.equals(this.testRunSteps(), other.testRunSteps()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListTestRunStepsResponse").add("TestRunSteps", this.hasTestRunSteps() ? this.testRunSteps() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "testRunSteps": {
                return Optional.ofNullable(clazz.cast(this.testRunSteps()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTestRunStepsResponse, T> g) {
        return obj -> g.apply((ListTestRunStepsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppTestResponse.BuilderImpl
    implements Builder {
        private List<TestRunStepSummary> testRunSteps = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTestRunStepsResponse model) {
            super(model);
            this.testRunSteps(model.testRunSteps);
            this.nextToken(model.nextToken);
        }

        public final List<TestRunStepSummary.Builder> getTestRunSteps() {
            List<TestRunStepSummary.Builder> result = TestRunStepSummaryListCopier.copyToBuilder(this.testRunSteps);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTestRunSteps(Collection<TestRunStepSummary.BuilderImpl> testRunSteps) {
            this.testRunSteps = TestRunStepSummaryListCopier.copyFromBuilder(testRunSteps);
        }

        @Override
        public final Builder testRunSteps(Collection<TestRunStepSummary> testRunSteps) {
            this.testRunSteps = TestRunStepSummaryListCopier.copy(testRunSteps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder testRunSteps(TestRunStepSummary ... testRunSteps) {
            this.testRunSteps(Arrays.asList(testRunSteps));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder testRunSteps(Consumer<TestRunStepSummary.Builder> ... testRunSteps) {
            this.testRunSteps(Stream.of(testRunSteps).map(c -> (TestRunStepSummary)((TestRunStepSummary.Builder)TestRunStepSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListTestRunStepsResponse build() {
            return new ListTestRunStepsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AppTestResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListTestRunStepsResponse> {
        public Builder testRunSteps(Collection<TestRunStepSummary> var1);

        public Builder testRunSteps(TestRunStepSummary ... var1);

        public Builder testRunSteps(Consumer<TestRunStepSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

