/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apptest.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.apptest.model.AppTestResponse;
import software.amazon.awssdk.services.apptest.model.TestRunSummary;
import software.amazon.awssdk.services.apptest.model.TestRunSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListTestRunsResponse
extends AppTestResponse
implements ToCopyableBuilder<Builder, ListTestRunsResponse> {
    private static final SdkField<List<TestRunSummary>> TEST_RUNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("testRuns").getter(ListTestRunsResponse.getter(ListTestRunsResponse::testRuns)).setter(ListTestRunsResponse.setter(Builder::testRuns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testRuns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TestRunSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListTestRunsResponse.getter(ListTestRunsResponse::nextToken)).setter(ListTestRunsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEST_RUNS_FIELD, NEXT_TOKEN_FIELD));
    private final List<TestRunSummary> testRuns;
    private final String nextToken;

    private ListTestRunsResponse(BuilderImpl builder) {
        super(builder);
        this.testRuns = builder.testRuns;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasTestRuns() {
        return this.testRuns != null && !(this.testRuns instanceof SdkAutoConstructList);
    }

    public final List<TestRunSummary> testRuns() {
        return this.testRuns;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTestRuns() ? this.testRuns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTestRunsResponse)) {
            return false;
        }
        ListTestRunsResponse other = (ListTestRunsResponse)((Object)obj);
        return this.hasTestRuns() == other.hasTestRuns() && Objects.equals(this.testRuns(), other.testRuns()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListTestRunsResponse").add("TestRuns", this.hasTestRuns() ? this.testRuns() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "testRuns": {
                return Optional.ofNullable(clazz.cast(this.testRuns()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTestRunsResponse, T> g) {
        return obj -> g.apply((ListTestRunsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppTestResponse.BuilderImpl
    implements Builder {
        private List<TestRunSummary> testRuns = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTestRunsResponse model) {
            super(model);
            this.testRuns(model.testRuns);
            this.nextToken(model.nextToken);
        }

        public final List<TestRunSummary.Builder> getTestRuns() {
            List<TestRunSummary.Builder> result = TestRunSummaryListCopier.copyToBuilder(this.testRuns);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTestRuns(Collection<TestRunSummary.BuilderImpl> testRuns) {
            this.testRuns = TestRunSummaryListCopier.copyFromBuilder(testRuns);
        }

        @Override
        public final Builder testRuns(Collection<TestRunSummary> testRuns) {
            this.testRuns = TestRunSummaryListCopier.copy(testRuns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder testRuns(TestRunSummary ... testRuns) {
            this.testRuns(Arrays.asList(testRuns));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder testRuns(Consumer<TestRunSummary.Builder> ... testRuns) {
            this.testRuns(Stream.of(testRuns).map(c -> (TestRunSummary)((TestRunSummary.Builder)TestRunSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListTestRunsResponse build() {
            return new ListTestRunsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AppTestResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListTestRunsResponse> {
        public Builder testRuns(Collection<TestRunSummary> var1);

        public Builder testRuns(TestRunSummary ... var1);

        public Builder testRuns(Consumer<TestRunSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

