/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apptest.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.apptest.AppTestClient;
import software.amazon.awssdk.services.apptest.internal.UserAgentUtils;
import software.amazon.awssdk.services.apptest.model.ListTestCasesRequest;
import software.amazon.awssdk.services.apptest.model.ListTestCasesResponse;
import software.amazon.awssdk.services.apptest.model.TestCaseSummary;

public class ListTestCasesIterable
implements SdkIterable<ListTestCasesResponse> {
    private final AppTestClient client;
    private final ListTestCasesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListTestCasesIterable(AppTestClient client, ListTestCasesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListTestCasesResponseFetcher();
    }

    public Iterator<ListTestCasesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<TestCaseSummary> testCases() {
        Function<ListTestCasesResponse, Iterator> getIterator = response -> {
            if (response != null && response.testCases() != null) {
                return response.testCases().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListTestCasesResponseFetcher
    implements SyncPageFetcher<ListTestCasesResponse> {
        private ListTestCasesResponseFetcher() {
        }

        public boolean hasNextPage(ListTestCasesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListTestCasesResponse nextPage(ListTestCasesResponse previousPage) {
            if (previousPage == null) {
                return ListTestCasesIterable.this.client.listTestCases(ListTestCasesIterable.this.firstRequest);
            }
            return ListTestCasesIterable.this.client.listTestCases((ListTestCasesRequest)((Object)ListTestCasesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

