/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apptest.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.apptest.AppTestAsyncClient;
import software.amazon.awssdk.services.apptest.internal.UserAgentUtils;
import software.amazon.awssdk.services.apptest.model.ListTestRunStepsRequest;
import software.amazon.awssdk.services.apptest.model.ListTestRunStepsResponse;
import software.amazon.awssdk.services.apptest.model.TestRunStepSummary;

public class ListTestRunStepsPublisher
implements SdkPublisher<ListTestRunStepsResponse> {
    private final AppTestAsyncClient client;
    private final ListTestRunStepsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListTestRunStepsPublisher(AppTestAsyncClient client, ListTestRunStepsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListTestRunStepsPublisher(AppTestAsyncClient client, ListTestRunStepsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListTestRunStepsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListTestRunStepsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<TestRunStepSummary> testRunSteps() {
        Function<ListTestRunStepsResponse, Iterator> getIterator = response -> {
            if (response != null && response.testRunSteps() != null) {
                return response.testRunSteps().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListTestRunStepsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListTestRunStepsResponseFetcher
    implements AsyncPageFetcher<ListTestRunStepsResponse> {
        private ListTestRunStepsResponseFetcher() {
        }

        public boolean hasNextPage(ListTestRunStepsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListTestRunStepsResponse> nextPage(ListTestRunStepsResponse previousPage) {
            if (previousPage == null) {
                return ListTestRunStepsPublisher.this.client.listTestRunSteps(ListTestRunStepsPublisher.this.firstRequest);
            }
            return ListTestRunStepsPublisher.this.client.listTestRunSteps((ListTestRunStepsRequest)((Object)ListTestRunStepsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

