/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apptest.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.apptest.AppTestClient;
import software.amazon.awssdk.services.apptest.internal.UserAgentUtils;
import software.amazon.awssdk.services.apptest.model.ListTestSuitesRequest;
import software.amazon.awssdk.services.apptest.model.ListTestSuitesResponse;
import software.amazon.awssdk.services.apptest.model.TestSuiteSummary;

public class ListTestSuitesIterable
implements SdkIterable<ListTestSuitesResponse> {
    private final AppTestClient client;
    private final ListTestSuitesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListTestSuitesIterable(AppTestClient client, ListTestSuitesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListTestSuitesResponseFetcher();
    }

    public Iterator<ListTestSuitesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<TestSuiteSummary> testSuites() {
        Function<ListTestSuitesResponse, Iterator> getIterator = response -> {
            if (response != null && response.testSuites() != null) {
                return response.testSuites().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListTestSuitesResponseFetcher
    implements SyncPageFetcher<ListTestSuitesResponse> {
        private ListTestSuitesResponseFetcher() {
        }

        public boolean hasNextPage(ListTestSuitesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListTestSuitesResponse nextPage(ListTestSuitesResponse previousPage) {
            if (previousPage == null) {
                return ListTestSuitesIterable.this.client.listTestSuites(ListTestSuitesIterable.this.firstRequest);
            }
            return ListTestSuitesIterable.this.client.listTestSuites((ListTestSuitesRequest)((Object)ListTestSuitesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

