/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a <code>StopDeployment</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StopDeploymentResponse extends CodeDeployResponse implements
        ToCopyableBuilder<StopDeploymentResponse.Builder, StopDeploymentResponse> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(StopDeploymentResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statusMessage").getter(getter(StopDeploymentResponse::statusMessage))
            .setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusMessage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD,
            STATUS_MESSAGE_FIELD));

    private final String status;

    private final String statusMessage;

    private StopDeploymentResponse(BuilderImpl builder) {
        super(builder);
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
    }

    /**
     * <p>
     * The status of the stop deployment operation:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Pending: The stop operation is pending.
     * </p>
     * </li>
     * <li>
     * <p>
     * Succeeded: The stop operation was successful.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link StopStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the stop deployment operation:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Pending: The stop operation is pending.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Succeeded: The stop operation was successful.
     *         </p>
     *         </li>
     * @see StopStatus
     */
    public final StopStatus status() {
        return StopStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the stop deployment operation:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Pending: The stop operation is pending.
     * </p>
     * </li>
     * <li>
     * <p>
     * Succeeded: The stop operation was successful.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link StopStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the stop deployment operation:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Pending: The stop operation is pending.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Succeeded: The stop operation was successful.
     *         </p>
     *         </li>
     * @see StopStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * An accompanying status message.
     * </p>
     * 
     * @return An accompanying status message.
     */
    public final String statusMessage() {
        return statusMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StopDeploymentResponse)) {
            return false;
        }
        StopDeploymentResponse other = (StopDeploymentResponse) obj;
        return Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(statusMessage(), other.statusMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StopDeploymentResponse").add("Status", statusAsString()).add("StatusMessage", statusMessage())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "statusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StopDeploymentResponse, T> g) {
        return obj -> g.apply((StopDeploymentResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeDeployResponse.Builder, SdkPojo, CopyableBuilder<Builder, StopDeploymentResponse> {
        /**
         * <p>
         * The status of the stop deployment operation:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Pending: The stop operation is pending.
         * </p>
         * </li>
         * <li>
         * <p>
         * Succeeded: The stop operation was successful.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the stop deployment operation:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Pending: The stop operation is pending.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Succeeded: The stop operation was successful.
         *        </p>
         *        </li>
         * @see StopStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StopStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the stop deployment operation:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Pending: The stop operation is pending.
         * </p>
         * </li>
         * <li>
         * <p>
         * Succeeded: The stop operation was successful.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the stop deployment operation:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Pending: The stop operation is pending.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Succeeded: The stop operation was successful.
         *        </p>
         *        </li>
         * @see StopStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StopStatus
         */
        Builder status(StopStatus status);

        /**
         * <p>
         * An accompanying status message.
         * </p>
         * 
         * @param statusMessage
         *        An accompanying status message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);
    }

    static final class BuilderImpl extends CodeDeployResponse.BuilderImpl implements Builder {
        private String status;

        private String statusMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(StopDeploymentResponse model) {
            super(model);
            status(model.status);
            statusMessage(model.statusMessage);
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(StopStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        @Override
        public StopDeploymentResponse build() {
            return new StopDeploymentResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
