/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codestar.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codestar.model.CodeStarRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssociateTeamMemberRequest
extends CodeStarRequest
implements ToCopyableBuilder<Builder, AssociateTeamMemberRequest> {
    private static final SdkField<String> PROJECT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("projectId").getter(AssociateTeamMemberRequest.getter(AssociateTeamMemberRequest::projectId)).setter(AssociateTeamMemberRequest.setter(Builder::projectId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectId").build()}).build();
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientRequestToken").getter(AssociateTeamMemberRequest.getter(AssociateTeamMemberRequest::clientRequestToken)).setter(AssociateTeamMemberRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestToken").build()}).build();
    private static final SdkField<String> USER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("userArn").getter(AssociateTeamMemberRequest.getter(AssociateTeamMemberRequest::userArn)).setter(AssociateTeamMemberRequest.setter(Builder::userArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userArn").build()}).build();
    private static final SdkField<String> PROJECT_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("projectRole").getter(AssociateTeamMemberRequest.getter(AssociateTeamMemberRequest::projectRole)).setter(AssociateTeamMemberRequest.setter(Builder::projectRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectRole").build()}).build();
    private static final SdkField<Boolean> REMOTE_ACCESS_ALLOWED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("remoteAccessAllowed").getter(AssociateTeamMemberRequest.getter(AssociateTeamMemberRequest::remoteAccessAllowed)).setter(AssociateTeamMemberRequest.setter(Builder::remoteAccessAllowed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("remoteAccessAllowed").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROJECT_ID_FIELD, CLIENT_REQUEST_TOKEN_FIELD, USER_ARN_FIELD, PROJECT_ROLE_FIELD, REMOTE_ACCESS_ALLOWED_FIELD));
    private final String projectId;
    private final String clientRequestToken;
    private final String userArn;
    private final String projectRole;
    private final Boolean remoteAccessAllowed;

    private AssociateTeamMemberRequest(BuilderImpl builder) {
        super(builder);
        this.projectId = builder.projectId;
        this.clientRequestToken = builder.clientRequestToken;
        this.userArn = builder.userArn;
        this.projectRole = builder.projectRole;
        this.remoteAccessAllowed = builder.remoteAccessAllowed;
    }

    public final String projectId() {
        return this.projectId;
    }

    public final String clientRequestToken() {
        return this.clientRequestToken;
    }

    public final String userArn() {
        return this.userArn;
    }

    public final String projectRole() {
        return this.projectRole;
    }

    public final Boolean remoteAccessAllowed() {
        return this.remoteAccessAllowed;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.projectId());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.userArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.projectRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.remoteAccessAllowed());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateTeamMemberRequest)) {
            return false;
        }
        AssociateTeamMemberRequest other = (AssociateTeamMemberRequest)((Object)obj);
        return Objects.equals(this.projectId(), other.projectId()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken()) && Objects.equals(this.userArn(), other.userArn()) && Objects.equals(this.projectRole(), other.projectRole()) && Objects.equals(this.remoteAccessAllowed(), other.remoteAccessAllowed());
    }

    public final String toString() {
        return ToString.builder((String)"AssociateTeamMemberRequest").add("ProjectId", (Object)this.projectId()).add("ClientRequestToken", (Object)this.clientRequestToken()).add("UserArn", (Object)this.userArn()).add("ProjectRole", (Object)this.projectRole()).add("RemoteAccessAllowed", (Object)this.remoteAccessAllowed()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "projectId": {
                return Optional.ofNullable(clazz.cast(this.projectId()));
            }
            case "clientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
            case "userArn": {
                return Optional.ofNullable(clazz.cast(this.userArn()));
            }
            case "projectRole": {
                return Optional.ofNullable(clazz.cast(this.projectRole()));
            }
            case "remoteAccessAllowed": {
                return Optional.ofNullable(clazz.cast(this.remoteAccessAllowed()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssociateTeamMemberRequest, T> g) {
        return obj -> g.apply((AssociateTeamMemberRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeStarRequest.BuilderImpl
    implements Builder {
        private String projectId;
        private String clientRequestToken;
        private String userArn;
        private String projectRole;
        private Boolean remoteAccessAllowed;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateTeamMemberRequest model) {
            super(model);
            this.projectId(model.projectId);
            this.clientRequestToken(model.clientRequestToken);
            this.userArn(model.userArn);
            this.projectRole(model.projectRole);
            this.remoteAccessAllowed(model.remoteAccessAllowed);
        }

        public final String getProjectId() {
            return this.projectId;
        }

        public final void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        @Override
        public final Builder projectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final String getUserArn() {
            return this.userArn;
        }

        public final void setUserArn(String userArn) {
            this.userArn = userArn;
        }

        @Override
        public final Builder userArn(String userArn) {
            this.userArn = userArn;
            return this;
        }

        public final String getProjectRole() {
            return this.projectRole;
        }

        public final void setProjectRole(String projectRole) {
            this.projectRole = projectRole;
        }

        @Override
        public final Builder projectRole(String projectRole) {
            this.projectRole = projectRole;
            return this;
        }

        public final Boolean getRemoteAccessAllowed() {
            return this.remoteAccessAllowed;
        }

        public final void setRemoteAccessAllowed(Boolean remoteAccessAllowed) {
            this.remoteAccessAllowed = remoteAccessAllowed;
        }

        @Override
        public final Builder remoteAccessAllowed(Boolean remoteAccessAllowed) {
            this.remoteAccessAllowed = remoteAccessAllowed;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateTeamMemberRequest build() {
            return new AssociateTeamMemberRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CodeStarRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AssociateTeamMemberRequest> {
        public Builder projectId(String var1);

        public Builder clientRequestToken(String var1);

        public Builder userArn(String var1);

        public Builder projectRole(String var1);

        public Builder remoteAccessAllowed(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

