/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databrew.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Connection information for dataset input files stored in a database.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DatabaseInputDefinition implements SdkPojo, Serializable,
        ToCopyableBuilder<DatabaseInputDefinition.Builder, DatabaseInputDefinition> {
    private static final SdkField<String> GLUE_CONNECTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GlueConnectionName").getter(getter(DatabaseInputDefinition::glueConnectionName))
            .setter(setter(Builder::glueConnectionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlueConnectionName").build())
            .build();

    private static final SdkField<String> DATABASE_TABLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatabaseTableName").getter(getter(DatabaseInputDefinition::databaseTableName))
            .setter(setter(Builder::databaseTableName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseTableName").build()).build();

    private static final SdkField<S3Location> TEMP_DIRECTORY_FIELD = SdkField.<S3Location> builder(MarshallingType.SDK_POJO)
            .memberName("TempDirectory").getter(getter(DatabaseInputDefinition::tempDirectory))
            .setter(setter(Builder::tempDirectory)).constructor(S3Location::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TempDirectory").build()).build();

    private static final SdkField<String> QUERY_STRING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QueryString").getter(getter(DatabaseInputDefinition::queryString)).setter(setter(Builder::queryString))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryString").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GLUE_CONNECTION_NAME_FIELD,
            DATABASE_TABLE_NAME_FIELD, TEMP_DIRECTORY_FIELD, QUERY_STRING_FIELD));

    private static final long serialVersionUID = 1L;

    private final String glueConnectionName;

    private final String databaseTableName;

    private final S3Location tempDirectory;

    private final String queryString;

    private DatabaseInputDefinition(BuilderImpl builder) {
        this.glueConnectionName = builder.glueConnectionName;
        this.databaseTableName = builder.databaseTableName;
        this.tempDirectory = builder.tempDirectory;
        this.queryString = builder.queryString;
    }

    /**
     * <p>
     * The Glue Connection that stores the connection information for the target database.
     * </p>
     * 
     * @return The Glue Connection that stores the connection information for the target database.
     */
    public final String glueConnectionName() {
        return glueConnectionName;
    }

    /**
     * <p>
     * The table within the target database.
     * </p>
     * 
     * @return The table within the target database.
     */
    public final String databaseTableName() {
        return databaseTableName;
    }

    /**
     * Returns the value of the TempDirectory property for this object.
     * 
     * @return The value of the TempDirectory property for this object.
     */
    public final S3Location tempDirectory() {
        return tempDirectory;
    }

    /**
     * <p>
     * Custom SQL to run against the provided Glue connection. This SQL will be used as the input for DataBrew projects
     * and jobs.
     * </p>
     * 
     * @return Custom SQL to run against the provided Glue connection. This SQL will be used as the input for DataBrew
     *         projects and jobs.
     */
    public final String queryString() {
        return queryString;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(glueConnectionName());
        hashCode = 31 * hashCode + Objects.hashCode(databaseTableName());
        hashCode = 31 * hashCode + Objects.hashCode(tempDirectory());
        hashCode = 31 * hashCode + Objects.hashCode(queryString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DatabaseInputDefinition)) {
            return false;
        }
        DatabaseInputDefinition other = (DatabaseInputDefinition) obj;
        return Objects.equals(glueConnectionName(), other.glueConnectionName())
                && Objects.equals(databaseTableName(), other.databaseTableName())
                && Objects.equals(tempDirectory(), other.tempDirectory()) && Objects.equals(queryString(), other.queryString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DatabaseInputDefinition").add("GlueConnectionName", glueConnectionName())
                .add("DatabaseTableName", databaseTableName()).add("TempDirectory", tempDirectory())
                .add("QueryString", queryString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GlueConnectionName":
            return Optional.ofNullable(clazz.cast(glueConnectionName()));
        case "DatabaseTableName":
            return Optional.ofNullable(clazz.cast(databaseTableName()));
        case "TempDirectory":
            return Optional.ofNullable(clazz.cast(tempDirectory()));
        case "QueryString":
            return Optional.ofNullable(clazz.cast(queryString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DatabaseInputDefinition, T> g) {
        return obj -> g.apply((DatabaseInputDefinition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DatabaseInputDefinition> {
        /**
         * <p>
         * The Glue Connection that stores the connection information for the target database.
         * </p>
         * 
         * @param glueConnectionName
         *        The Glue Connection that stores the connection information for the target database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder glueConnectionName(String glueConnectionName);

        /**
         * <p>
         * The table within the target database.
         * </p>
         * 
         * @param databaseTableName
         *        The table within the target database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseTableName(String databaseTableName);

        /**
         * Sets the value of the TempDirectory property for this object.
         *
         * @param tempDirectory
         *        The new value for the TempDirectory property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tempDirectory(S3Location tempDirectory);

        /**
         * Sets the value of the TempDirectory property for this object.
         *
         * This is a convenience method that creates an instance of the {@link S3Location.Builder} avoiding the need to
         * create one manually via {@link S3Location#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3Location.Builder#build()} is called immediately and its result
         * is passed to {@link #tempDirectory(S3Location)}.
         * 
         * @param tempDirectory
         *        a consumer that will call methods on {@link S3Location.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tempDirectory(S3Location)
         */
        default Builder tempDirectory(Consumer<S3Location.Builder> tempDirectory) {
            return tempDirectory(S3Location.builder().applyMutation(tempDirectory).build());
        }

        /**
         * <p>
         * Custom SQL to run against the provided Glue connection. This SQL will be used as the input for DataBrew
         * projects and jobs.
         * </p>
         * 
         * @param queryString
         *        Custom SQL to run against the provided Glue connection. This SQL will be used as the input for
         *        DataBrew projects and jobs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryString(String queryString);
    }

    static final class BuilderImpl implements Builder {
        private String glueConnectionName;

        private String databaseTableName;

        private S3Location tempDirectory;

        private String queryString;

        private BuilderImpl() {
        }

        private BuilderImpl(DatabaseInputDefinition model) {
            glueConnectionName(model.glueConnectionName);
            databaseTableName(model.databaseTableName);
            tempDirectory(model.tempDirectory);
            queryString(model.queryString);
        }

        public final String getGlueConnectionName() {
            return glueConnectionName;
        }

        public final void setGlueConnectionName(String glueConnectionName) {
            this.glueConnectionName = glueConnectionName;
        }

        @Override
        public final Builder glueConnectionName(String glueConnectionName) {
            this.glueConnectionName = glueConnectionName;
            return this;
        }

        public final String getDatabaseTableName() {
            return databaseTableName;
        }

        public final void setDatabaseTableName(String databaseTableName) {
            this.databaseTableName = databaseTableName;
        }

        @Override
        public final Builder databaseTableName(String databaseTableName) {
            this.databaseTableName = databaseTableName;
            return this;
        }

        public final S3Location.Builder getTempDirectory() {
            return tempDirectory != null ? tempDirectory.toBuilder() : null;
        }

        public final void setTempDirectory(S3Location.BuilderImpl tempDirectory) {
            this.tempDirectory = tempDirectory != null ? tempDirectory.build() : null;
        }

        @Override
        public final Builder tempDirectory(S3Location tempDirectory) {
            this.tempDirectory = tempDirectory;
            return this;
        }

        public final String getQueryString() {
            return queryString;
        }

        public final void setQueryString(String queryString) {
            this.queryString = queryString;
        }

        @Override
        public final Builder queryString(String queryString) {
            this.queryString = queryString;
            return this;
        }

        @Override
        public DatabaseInputDefinition build() {
            return new DatabaseInputDefinition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
