/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databrew.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

@Generated("software.amazon.awssdk:codegen")
public enum ThresholdType {
    GREATER_THAN_OR_EQUAL("GREATER_THAN_OR_EQUAL"),

    LESS_THAN_OR_EQUAL("LESS_THAN_OR_EQUAL"),

    GREATER_THAN("GREATER_THAN"),

    LESS_THAN("LESS_THAN"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ThresholdType> VALUE_MAP = EnumUtils.uniqueIndex(ThresholdType.class,
            ThresholdType::toString);

    private final String value;

    private ThresholdType(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return ThresholdType corresponding to the value
     */
    public static ThresholdType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link ThresholdType}s
     */
    public static Set<ThresholdType> knownValues() {
        Set<ThresholdType> knownValues = EnumSet.allOf(ThresholdType.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
