/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databrew.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.databrew.model.S3Location;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataCatalogInputDefinition
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataCatalogInputDefinition> {
    private static final SdkField<String> CATALOG_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CatalogId").getter(DataCatalogInputDefinition.getter(DataCatalogInputDefinition::catalogId)).setter(DataCatalogInputDefinition.setter(Builder::catalogId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogId").build()}).build();
    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatabaseName").getter(DataCatalogInputDefinition.getter(DataCatalogInputDefinition::databaseName)).setter(DataCatalogInputDefinition.setter(Builder::databaseName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()}).build();
    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TableName").getter(DataCatalogInputDefinition.getter(DataCatalogInputDefinition::tableName)).setter(DataCatalogInputDefinition.setter(Builder::tableName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableName").build()}).build();
    private static final SdkField<S3Location> TEMP_DIRECTORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TempDirectory").getter(DataCatalogInputDefinition.getter(DataCatalogInputDefinition::tempDirectory)).setter(DataCatalogInputDefinition.setter(Builder::tempDirectory)).constructor(S3Location::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TempDirectory").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_ID_FIELD, DATABASE_NAME_FIELD, TABLE_NAME_FIELD, TEMP_DIRECTORY_FIELD));
    private static final long serialVersionUID = 1L;
    private final String catalogId;
    private final String databaseName;
    private final String tableName;
    private final S3Location tempDirectory;

    private DataCatalogInputDefinition(BuilderImpl builder) {
        this.catalogId = builder.catalogId;
        this.databaseName = builder.databaseName;
        this.tableName = builder.tableName;
        this.tempDirectory = builder.tempDirectory;
    }

    public final String catalogId() {
        return this.catalogId;
    }

    public final String databaseName() {
        return this.databaseName;
    }

    public final String tableName() {
        return this.tableName;
    }

    public final S3Location tempDirectory() {
        return this.tempDirectory;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.catalogId());
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableName());
        hashCode = 31 * hashCode + Objects.hashCode(this.tempDirectory());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataCatalogInputDefinition)) {
            return false;
        }
        DataCatalogInputDefinition other = (DataCatalogInputDefinition)obj;
        return Objects.equals(this.catalogId(), other.catalogId()) && Objects.equals(this.databaseName(), other.databaseName()) && Objects.equals(this.tableName(), other.tableName()) && Objects.equals(this.tempDirectory(), other.tempDirectory());
    }

    public final String toString() {
        return ToString.builder((String)"DataCatalogInputDefinition").add("CatalogId", (Object)this.catalogId()).add("DatabaseName", (Object)this.databaseName()).add("TableName", (Object)this.tableName()).add("TempDirectory", (Object)this.tempDirectory()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CatalogId": {
                return Optional.ofNullable(clazz.cast(this.catalogId()));
            }
            case "DatabaseName": {
                return Optional.ofNullable(clazz.cast(this.databaseName()));
            }
            case "TableName": {
                return Optional.ofNullable(clazz.cast(this.tableName()));
            }
            case "TempDirectory": {
                return Optional.ofNullable(clazz.cast(this.tempDirectory()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataCatalogInputDefinition, T> g) {
        return obj -> g.apply((DataCatalogInputDefinition)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String catalogId;
        private String databaseName;
        private String tableName;
        private S3Location tempDirectory;

        private BuilderImpl() {
        }

        private BuilderImpl(DataCatalogInputDefinition model) {
            this.catalogId(model.catalogId);
            this.databaseName(model.databaseName);
            this.tableName(model.tableName);
            this.tempDirectory(model.tempDirectory);
        }

        public final String getCatalogId() {
            return this.catalogId;
        }

        public final void setCatalogId(String catalogId) {
            this.catalogId = catalogId;
        }

        @Override
        public final Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public final String getDatabaseName() {
            return this.databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final String getTableName() {
            return this.tableName;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final S3Location.Builder getTempDirectory() {
            return this.tempDirectory != null ? this.tempDirectory.toBuilder() : null;
        }

        public final void setTempDirectory(S3Location.BuilderImpl tempDirectory) {
            this.tempDirectory = tempDirectory != null ? tempDirectory.build() : null;
        }

        @Override
        public final Builder tempDirectory(S3Location tempDirectory) {
            this.tempDirectory = tempDirectory;
            return this;
        }

        public DataCatalogInputDefinition build() {
            return new DataCatalogInputDefinition(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataCatalogInputDefinition> {
        public Builder catalogId(String var1);

        public Builder databaseName(String var1);

        public Builder tableName(String var1);

        public Builder tempDirectory(S3Location var1);

        default public Builder tempDirectory(Consumer<S3Location.Builder> tempDirectory) {
            return this.tempDirectory((S3Location)((S3Location.Builder)S3Location.builder().applyMutation(tempDirectory)).build());
        }
    }
}

