/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databrew.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.databrew.DataBrewClient;
import software.amazon.awssdk.services.databrew.internal.UserAgentUtils;
import software.amazon.awssdk.services.databrew.model.ListRecipeVersionsRequest;
import software.amazon.awssdk.services.databrew.model.ListRecipeVersionsResponse;
import software.amazon.awssdk.services.databrew.model.Recipe;

public class ListRecipeVersionsIterable
implements SdkIterable<ListRecipeVersionsResponse> {
    private final DataBrewClient client;
    private final ListRecipeVersionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListRecipeVersionsIterable(DataBrewClient client, ListRecipeVersionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListRecipeVersionsResponseFetcher();
    }

    public Iterator<ListRecipeVersionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Recipe> recipes() {
        Function<ListRecipeVersionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.recipes() != null) {
                return response.recipes().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListRecipeVersionsResponseFetcher
    implements SyncPageFetcher<ListRecipeVersionsResponse> {
        private ListRecipeVersionsResponseFetcher() {
        }

        public boolean hasNextPage(ListRecipeVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListRecipeVersionsResponse nextPage(ListRecipeVersionsResponse previousPage) {
            if (previousPage == null) {
                return ListRecipeVersionsIterable.this.client.listRecipeVersions(ListRecipeVersionsIterable.this.firstRequest);
            }
            return ListRecipeVersionsIterable.this.client.listRecipeVersions((ListRecipeVersionsRequest)((Object)ListRecipeVersionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

