/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eks.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociateAccessPolicyRequest extends EksRequest implements
        ToCopyableBuilder<AssociateAccessPolicyRequest.Builder, AssociateAccessPolicyRequest> {
    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clusterName").getter(getter(AssociateAccessPolicyRequest::clusterName))
            .setter(setter(Builder::clusterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("name").build()).build();

    private static final SdkField<String> PRINCIPAL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("principalArn").getter(getter(AssociateAccessPolicyRequest::principalArn))
            .setter(setter(Builder::principalArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("principalArn").build()).build();

    private static final SdkField<String> POLICY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("policyArn").getter(getter(AssociateAccessPolicyRequest::policyArn)).setter(setter(Builder::policyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyArn").build()).build();

    private static final SdkField<AccessScope> ACCESS_SCOPE_FIELD = SdkField.<AccessScope> builder(MarshallingType.SDK_POJO)
            .memberName("accessScope").getter(getter(AssociateAccessPolicyRequest::accessScope))
            .setter(setter(Builder::accessScope)).constructor(AccessScope::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessScope").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_NAME_FIELD,
            PRINCIPAL_ARN_FIELD, POLICY_ARN_FIELD, ACCESS_SCOPE_FIELD));

    private final String clusterName;

    private final String principalArn;

    private final String policyArn;

    private final AccessScope accessScope;

    private AssociateAccessPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.clusterName = builder.clusterName;
        this.principalArn = builder.principalArn;
        this.policyArn = builder.policyArn;
        this.accessScope = builder.accessScope;
    }

    /**
     * <p>
     * The name of your cluster.
     * </p>
     * 
     * @return The name of your cluster.
     */
    public final String clusterName() {
        return clusterName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM user or role for the <code>AccessEntry</code> that you're associating
     * the access policy to.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM user or role for the <code>AccessEntry</code> that you're
     *         associating the access policy to.
     */
    public final String principalArn() {
        return principalArn;
    }

    /**
     * <p>
     * The ARN of the <code>AccessPolicy</code> that you're associating. For a list of ARNs, use
     * <code>ListAccessPolicies</code>.
     * </p>
     * 
     * @return The ARN of the <code>AccessPolicy</code> that you're associating. For a list of ARNs, use
     *         <code>ListAccessPolicies</code>.
     */
    public final String policyArn() {
        return policyArn;
    }

    /**
     * <p>
     * The scope for the <code>AccessPolicy</code>. You can scope access policies to an entire cluster or to specific
     * Kubernetes namespaces.
     * </p>
     * 
     * @return The scope for the <code>AccessPolicy</code>. You can scope access policies to an entire cluster or to
     *         specific Kubernetes namespaces.
     */
    public final AccessScope accessScope() {
        return accessScope;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(principalArn());
        hashCode = 31 * hashCode + Objects.hashCode(policyArn());
        hashCode = 31 * hashCode + Objects.hashCode(accessScope());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateAccessPolicyRequest)) {
            return false;
        }
        AssociateAccessPolicyRequest other = (AssociateAccessPolicyRequest) obj;
        return Objects.equals(clusterName(), other.clusterName()) && Objects.equals(principalArn(), other.principalArn())
                && Objects.equals(policyArn(), other.policyArn()) && Objects.equals(accessScope(), other.accessScope());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssociateAccessPolicyRequest").add("ClusterName", clusterName())
                .add("PrincipalArn", principalArn()).add("PolicyArn", policyArn()).add("AccessScope", accessScope()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clusterName":
            return Optional.ofNullable(clazz.cast(clusterName()));
        case "principalArn":
            return Optional.ofNullable(clazz.cast(principalArn()));
        case "policyArn":
            return Optional.ofNullable(clazz.cast(policyArn()));
        case "accessScope":
            return Optional.ofNullable(clazz.cast(accessScope()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssociateAccessPolicyRequest, T> g) {
        return obj -> g.apply((AssociateAccessPolicyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EksRequest.Builder, SdkPojo, CopyableBuilder<Builder, AssociateAccessPolicyRequest> {
        /**
         * <p>
         * The name of your cluster.
         * </p>
         * 
         * @param clusterName
         *        The name of your cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterName(String clusterName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM user or role for the <code>AccessEntry</code> that you're
         * associating the access policy to.
         * </p>
         * 
         * @param principalArn
         *        The Amazon Resource Name (ARN) of the IAM user or role for the <code>AccessEntry</code> that you're
         *        associating the access policy to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principalArn(String principalArn);

        /**
         * <p>
         * The ARN of the <code>AccessPolicy</code> that you're associating. For a list of ARNs, use
         * <code>ListAccessPolicies</code>.
         * </p>
         * 
         * @param policyArn
         *        The ARN of the <code>AccessPolicy</code> that you're associating. For a list of ARNs, use
         *        <code>ListAccessPolicies</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyArn(String policyArn);

        /**
         * <p>
         * The scope for the <code>AccessPolicy</code>. You can scope access policies to an entire cluster or to
         * specific Kubernetes namespaces.
         * </p>
         * 
         * @param accessScope
         *        The scope for the <code>AccessPolicy</code>. You can scope access policies to an entire cluster or to
         *        specific Kubernetes namespaces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessScope(AccessScope accessScope);

        /**
         * <p>
         * The scope for the <code>AccessPolicy</code>. You can scope access policies to an entire cluster or to
         * specific Kubernetes namespaces.
         * </p>
         * This is a convenience method that creates an instance of the {@link AccessScope.Builder} avoiding the need to
         * create one manually via {@link AccessScope#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AccessScope.Builder#build()} is called immediately and its result
         * is passed to {@link #accessScope(AccessScope)}.
         * 
         * @param accessScope
         *        a consumer that will call methods on {@link AccessScope.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accessScope(AccessScope)
         */
        default Builder accessScope(Consumer<AccessScope.Builder> accessScope) {
            return accessScope(AccessScope.builder().applyMutation(accessScope).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EksRequest.BuilderImpl implements Builder {
        private String clusterName;

        private String principalArn;

        private String policyArn;

        private AccessScope accessScope;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateAccessPolicyRequest model) {
            super(model);
            clusterName(model.clusterName);
            principalArn(model.principalArn);
            policyArn(model.policyArn);
            accessScope(model.accessScope);
        }

        public final String getClusterName() {
            return clusterName;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final String getPrincipalArn() {
            return principalArn;
        }

        public final void setPrincipalArn(String principalArn) {
            this.principalArn = principalArn;
        }

        @Override
        public final Builder principalArn(String principalArn) {
            this.principalArn = principalArn;
            return this;
        }

        public final String getPolicyArn() {
            return policyArn;
        }

        public final void setPolicyArn(String policyArn) {
            this.policyArn = policyArn;
        }

        @Override
        public final Builder policyArn(String policyArn) {
            this.policyArn = policyArn;
            return this;
        }

        public final AccessScope.Builder getAccessScope() {
            return accessScope != null ? accessScope.toBuilder() : null;
        }

        public final void setAccessScope(AccessScope.BuilderImpl accessScope) {
            this.accessScope = accessScope != null ? accessScope.build() : null;
        }

        @Override
        public final Builder accessScope(AccessScope accessScope) {
            this.accessScope = accessScope;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateAccessPolicyRequest build() {
            return new AssociateAccessPolicyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
